/*
 * Created on 25-nov-2008
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.client.jsba.DBObject;

/**
 * A DmlAddCommand is the command that will make sure that a tuple will be added to the named relvar (in the target database to which this command will be sent) for the object passed to the constructor. The command will fail if that tuple is already present in that relvar.
 * 
 * @author Erwin Smout
 */
public final class DmlAddCommand extends DmlSingleAssignmentCommand {

	/**
	 * The byte code identifying the 'ADD' assignment type within the messages system
	 */
	public static final byte ASSIGNMENTTYPE = 1;

	/**
	 * The textual version of the command as it will be sent to a SIRA_PRISE server
	 */
	private String command;

	/**
	 * Creates the command object. See the DmlAssignmentCommand doc for an explanation of how the relvar's heading and the object's class must correspond to one another.
	 * 
	 * @param relvarName
	 *            The name of the relvar in which a tuple for the object is to be added
	 * @param dbObject
	 *            The object for which a tuple is to be added in the named relvar
	 */
	public DmlAddCommand (String relvarName, DBObject dbObject) {
		super(relvarName, dbObject);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getCommand()
	 */
	public String getCommand ( ) {
		if (command == null) {
			command = COMMANDNAMES.ADD + " " + getRelvarName() + "," + getRelationText(); //$NON-NLS-1$//$NON-NLS-2$
		}
		return command;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getServerCommand()
	 */
	@Override
	public ServerCommand getServerCommand ( ) {
		return new ServerAddCommand(getRelvarName(), getRelationText());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return getCommand();
	}
}