/*
 * Created on 25-nov-2008
 */
package be.SIRAPRISE.client;

/**
 * DmlCommand objects are the objects that represent dml Commands that can be executed in a transaction, on a connection to a SIRA_PRISE database
 * 
 * @author Erwin Smout
 */
public abstract class DmlCommand {

	/**
	 * Gets the command text
	 * 
	 * @return the command text
	 */
	public abstract String getCommand ( );

	/**
	 * Gets the ServerCommand object representing this dml command
	 * 
	 * @return the ServerCommand object representing this dml command
	 */
	public abstract ServerCommand getServerCommand ( );

	/**
	 * Invoked after successfull execution
	 */
	abstract void success ( );
}