/**
 * 
 */
package be.SIRAPRISE.client;

import java.util.LinkedList;

/**
 * @author Erwin
 * 
 */
public final class DmlMultipleAssignmentCommand extends DmlAssignmentCommand {

	/**
	 * 
	 */
	private DmlSingleAssignmentCommand[] individualAssignments;

	/**
	 * Creates the command object. See the DmlAssignmentCommand doc for an explanation of how the relvar's heading and the object's class must correspond to one another.
	 * 
	 * @param individualAssignments
	 *            The individual assignments that make up the multiple assignment. If an individual assignment is itself a Multiple Assignment MA, the individual assignments that constitute it will take the place of MA in the Ma object being constructed.
	 */
	public DmlMultipleAssignmentCommand (DmlAssignmentCommand[] individualAssignments) {
		LinkedList<DmlSingleAssignmentCommand> individualAssignmentsList = new LinkedList<DmlSingleAssignmentCommand>();

		for (DmlAssignmentCommand individualAssignment : individualAssignments) {
			if (individualAssignment instanceof DmlSingleAssignmentCommand) {
				individualAssignmentsList.addLast((DmlSingleAssignmentCommand) individualAssignment);
			} else {
				for (DmlSingleAssignmentCommand dmlSingleAssignmentCommand : ((DmlMultipleAssignmentCommand) individualAssignment).getIndividualAssignments()) {
					individualAssignmentsList.addLast(dmlSingleAssignmentCommand);
				}
			}
		}

		this.individualAssignments = individualAssignmentsList.toArray(new DmlSingleAssignmentCommand[] {});
	}

	/**
	 * Creates the command object. See the DmlAssignmentCommand doc for an explanation of how the relvar's heading and the object's class must correspond to one another.
	 * 
	 * @param individualAssignments
	 *            The individual assignments that make up the multiple assignment
	 */
	public DmlMultipleAssignmentCommand (DmlSingleAssignmentCommand[] individualAssignments) {
		this.individualAssignments = individualAssignments;
	}

	/**
	 * Gets individualAssignments
	 * 
	 * @return individualAssignments.
	 */
	private final DmlSingleAssignmentCommand[] getIndividualAssignments ( ) {
		return individualAssignments;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#success()
	 */
	@Override
	void success ( ) {
		for (DmlSingleAssignmentCommand individualAssignment : individualAssignments) {
			individualAssignment.success();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getCommand()
	 */
	@Override
	public String getCommand ( ) {
		StringBuilder cmd = new StringBuilder(256 * individualAssignments.length);
		for (DmlSingleAssignmentCommand individualAssignment : individualAssignments) {
			cmd.append("CMD(").append(individualAssignment.getCommand()).append(')'); //$NON-NLS-1$
		}

		return cmd.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getServerCommand()
	 */
	@Override
	public ServerCommand getServerCommand ( ) {
		ServerSingleAssignmentCommand[] individualServerCommands = new ServerSingleAssignmentCommand[individualAssignments.length];
		int i = 0;
		for (DmlSingleAssignmentCommand individualAssignment : individualAssignments) {
			individualServerCommands[i++] = (ServerSingleAssignmentCommand) individualAssignment.getServerCommand();
		}

		return new ServerMultipleAssignmentCommand(individualServerCommands);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return getCommand();
	}
}
