/*
 * Created on 25-nov-2008
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.client.jsba.DBObject;

/**
 * A DmlUnassertCommand is the command that will make sure that a tuple will not exist in the named relvar (in the target database to which this command will be sent) for the object passed to the constructor. The command will not fail if that tuple is not present in that relvar.
 * 
 * @author Erwin Smout
 */
public final class DmlUnassertCommand extends DmlSingleAssignmentCommand {

	/**
	 * The byte code identifying the 'ASSERT' assignment type within the messages system
	 */
	public static final byte ASSIGNMENTTYPE = 6;

	/**
	 * The textual version of the command as it will be sent to the server
	 */
	private String command;

	/**
	 * Creates the command object. See the DmlAssignmentCommand doc for an explanation of how the relvar's heading and the object's class must correspond to one another.
	 * 
	 * @param relvarName
	 *            The name of the relvar in which a tuple for the object is to be added
	 * @param dbObject
	 *            The object for which a tuple is to be added in the named relvar
	 */
	public DmlUnassertCommand (String relvarName, DBObject dbObject) {
		super(relvarName, dbObject);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getCommand()
	 */
	public String getCommand ( ) {
		if (command == null) {
			command = COMMANDNAMES.UNASSERT + " " + getRelvarName() + "," + getRelationText(); //$NON-NLS-1$ //$NON-NLS-2$
		}
		return command;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getServerCommand()
	 */
	@Override
	public ServerCommand getServerCommand ( ) {
		return new ServerUnassertCommand(getRelvarName(), getRelationText());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return getCommand();
	}
}