/*
 * Created on 25-nov-2008
 */
package be.SIRAPRISE.client;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Map.Entry;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.client.jsba.JSBAMethodInvoker;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;

/**
 * A DmlUpdateCommand is the command that will replace a tuple with another one in the named relvar (in the target database to which this command will be sent) for the object passed to the constructor. The replaced tuple is determined by the object's getPreUpdateState() return object (which must be of the same class as the object itself), the replacing tuple by the object itself. The command will fail if the replaced tuple is not present in the named relvar, or if the replacing tuple is already present.
 * 
 * @author Erwin Smout
 */
public final class DmlUpdateCommand extends DmlSingleAssignmentCommand {

	/**
	 * The byte code identifying the 'UPDATE' assignment type within the messages system
	 */
	public static final byte ASSIGNMENTTYPE = 3;

	/**
	 * The textual version of the command as it will be sent to the server
	 */
	private String command;

	/**
	 * 
	 */
	private String updatedTuple;

	/**
	 * 
	 */
	private String updateList;

	/**
	 * Creates the command object. See the DmlAssignmentCommand doc for an explanation of how the relvar's heading and the object's class must correspond to one another.
	 * 
	 * @param relvarName
	 *            The name of the relvar in which a tuple for the object is to be added.
	 * @param o
	 *            The object for which a tuple is to be added in the named relvar
	 * @throws NoUpdatesException
	 *             if no attribute value changes at all are detected
	 * @throws IllegalArgumentException
	 *             If relvarName or o are null, or if relvarName is the zero-length string, or the getPreUpdateState() method of o returns either null or an object that is not of the same class as o.
	 */
	public DmlUpdateCommand (String relvarName, UpdatableDBObject o) throws NoUpdatesException {
		super(relvarName, o);

		StringBuilder updatedTupleBuilder = new StringBuilder(relvarName.toUpperCase() + "(TUPLE("); //$NON-NLS-1$
//		updateListBuilder = new StringBuilder("("); //$NON-NLS-1$
		StringBuilder updateListBuilder = new StringBuilder();
		UpdatableDBObject oldO = o.getPreUpdateState();

		if (oldO == null || oldO.getClass() != o.getClass() || o == oldO) {
			throw new IllegalArgumentException();
		}

		Map<String, JSBAMethodInvoker> getterMethods = getGetterMethods();
		boolean anyUpdates = false;
		for (Entry<String, JSBAMethodInvoker> me : getterMethods.entrySet()) {
			String attributeName = me.getKey();
			JSBAMethodInvoker attributeGetterMethod = me.getValue();
			String oldObjectAttributeValue;
			String newObjectAttributeValue;
			try {
				oldObjectAttributeValue = attributeGetterMethod.invoke(oldO, (Object[]) null);
				newObjectAttributeValue = attributeGetterMethod.invoke(o, (Object[]) null);
			} catch (IllegalAccessException e) {
				throw new RuntimeException(e);
			} catch (InvocationTargetException e) {
				throw new RuntimeException(e.getCause());
			}
			updatedTupleBuilder.append(attributeName).append('(').append(oldObjectAttributeValue).append(')');
			if (!oldObjectAttributeValue.equals(newObjectAttributeValue)) {
				updateListBuilder.append(attributeName).append('(').append(newObjectAttributeValue).append(')');
				anyUpdates = true;
			}
		}
		updatedTupleBuilder.append("))"); //$NON-NLS-1$
//		updateListBuilder.append(")"); //$NON-NLS-1$

		if (!anyUpdates) {
			throw new NoUpdatesException();
		}
		
		updatedTuple = updatedTupleBuilder.toString();
		updateList = updateListBuilder.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getCommand()
	 */
	public String getCommand ( ) {
		if (command == null) {
			command = COMMANDNAMES.UPDATE + " " + getRelvarName() + ',' + updatedTuple + ',' + '(' + updateList + ')'; //$NON-NLS-1$
		}
		return command;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DmlCommand#getServerCommand()
	 */
	@Override
	public ServerCommand getServerCommand ( ) {
		return new ServerUpdateCommand(getRelvarName(), updatedTuple, updateList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return getCommand();
	}
}