/*
 * Created on 14-okt-2008
 */
package be.SIRAPRISE.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Class holding a utility method to replace the <>'"& tokens with XML entity refs in XML output
 * 
 * @author Erwin Smout
 */
public class EntityRefs {

	/**
	 * 
	 */
	private static final Version FOUR_NIL = new Version((short) 4, (short) 0);

	/**
	 * 
	 */
	private static HashMap<String, String> html20Map;

	/**
	 * 
	 */
	private static HashMap<String, String> html32Map;

	/**
	 * 
	 */
	private static HashMap<String, String> html40Map;

	/**
	 * 
	 */
	private static Version THREE_TWO = new Version((short) 3, (short) 2);

	/**
	 * 
	 */
	private static Version TWO_NIL = new Version((short) 2, (short) 0);

	/**
	 * 
	 */
	private static HashMap<String, String> xhtml10Map;

	/**
	 * 
	 */
	static {
		html20Map = new HashMap<String, String>();
		html20Map.put("&quot;", "U+0022"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&amp;", "U+0026"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&lt;", "U+003C"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&gt;", "U+003E"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Agrave;", "U+00C0"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Aacute;", "U+00C1"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Acirc;", "U+00C2"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Atilde;", "U+00C3"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Auml;", "U+00C4"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Aring;", "U+00C5"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&AElig;", "U+00C6"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ccedil;", "U+00C7"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Egrave;", "U+00C8"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Eacute;", "U+00C9"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ecirc;", "U+00CA"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Euml;", "U+00CB"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Igrave;", "U+00CC"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Iacute;", "U+00CD"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Icirc;", "U+00CE"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Iuml;", "U+00CF"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ETH;", "U+00D0"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ntilde;", "U+00D1"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ograve;", "U+00D2"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Oacute;", "U+00D3"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ocirc;", "U+00D4"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Otilde;", "U+00D5"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ouml;", "U+00D6"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Oslash;", "U+00D8"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ugrave;", "U+00D9"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Uacute;", "U+00DA"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Ucirc;", "U+00DB"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Uuml;", "U+00DC"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&Yacute;", "U+00DD"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&THORN;", "U+00DE"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&szlig;", "U+00DF"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&agrave;", "U+00E0"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&aacute;", "U+00E1"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&acirc;", "U+00E2"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&atilde;", "U+00E3"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&auml;", "U+00E4"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&aring;", "U+00E5"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&aelig;", "U+00E6"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ccedil;", "U+00E7"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&egrave;", "U+00E8"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&eacute;", "U+00E9"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ecirc;", "U+00EA"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&euml;", "U+00EB"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&igrave;", "U+00EC"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&iacute;", "U+00ED"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&icirc;", "U+00EE"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&iuml;", "U+00EF"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&eth;", "U+00F0"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ntilde;", "U+00F1"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ograve;", "U+00F2"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&oacute;", "U+00F3"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ocirc;", "U+00F4"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&otilde;", "U+00F5"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ouml;", "U+00F6"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&oslash;", "U+00F8"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ugrave;", "U+00F9"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&uacute;", "U+00FA"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&ucirc;", "U+00FB"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&uuml;", "U+00FC"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&yacute;", "U+00FD"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&thorn;", "U+00FE"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("&yuml;", "U+00FF"); //$NON-NLS-1$ //$NON-NLS-2$

		html32Map = new HashMap<String, String>();
		html32Map.put("&Otimes;", "U+00D7"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&divide;", "U+00F7"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&nbsp;", "U+00A0"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&iexcl;", "U+00A1"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&cent;", "U+00A2"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&pound;", "U+00A3"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&curren;", "U+00A4"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&yen;", "U+00A5"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&brvbar;", "U+00A6"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&sect;", "U+00A7"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&uml;", "U+00A8"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&copy;", "U+00A9"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&ordf;", "U+00AA"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("&laquo;", "U+00AB"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&not;", "U+00AC"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&shy;", "U+00AD"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&reg;", "U+00AE"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&macr;", "U+00AF"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&deg;", "U+00B0"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&plusmn;", "U+00B1"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&sup2;", "U+00B2"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&sup3;", "U+00B3"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&acute;", "U+00B4"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&micro;", "U+00B5"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&para;", "U+00B6"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&middot;", "U+00B7"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&cedil;", "U+00B8"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&sup1;", "U+00B9"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&ordm;", "U+00BA"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&raquo;", "U+00BB"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&frac14;", "U+00BC"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&frac12;", "U+00BD"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&frac34;", "U+00BE"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("&iquest;", "U+00BF"); //$NON-NLS-1$ //$NON-NLS-2$

		html40Map = new HashMap<String, String>();
		html40Map.put("&OElig;", "U+0152"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&oelig;", "U+0153"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Scaron;", "U+0160"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&scaron;", "U+0161"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Yuml;", "U+0178"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&fnof;", "U+0192"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&circ;", "U+02C6"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&tilde;", "U+02DC"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Alpha;", "U+0391"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Beta;", "U+0392"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Gamma;", "U+0393"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Delta;", "U+0394"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Epsilon;", "U+0395"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Zeta;", "U+0396"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Eta;", "U+0397"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Theta;", "U+0398"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Iota;", "U+0399"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Kappa;", "U+039A"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Lambda;", "U+039B"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Mu;", "U+039C"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Nu;", "U+039D"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Xi;", "U+039E"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Omicron;", "U+039F"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Pi;", "U+03A0"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Rho;", "U+03A1"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Sigma;", "U+03A3"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Tau;", "U+03A4"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Upsilon;", "U+03A5"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Phi;", "U+03A6"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Chi;", "U+03A7"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&Psi;", "U+03A8"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Omega;", "U+03A9"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&alpha;", "U+03B1"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&beta;", "U+03B2"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&gamma;", "U+03B3"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&delta;", "U+03B4"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&epsilon;", "U+03B5"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&zeta;", "U+03B6"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&eta;", "U+03B7"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&theta;", "U+03B8"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&iota;", "U+03B9"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&kappa;", "U+03BA"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lambda;", "U+03BB"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&mu;", "U+03BC"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&nu;", "U+03BD"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&xi;", "U+03BE"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&omicron;", "U+03BF"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&pi;", "U+03C0"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&rho;", "U+03C1"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sigmaf;", "U+03C2"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sigma;", "U+03C3"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&tau;", "U+03C4"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&upsilon;", "U+03C5"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&phi;", "U+03C6"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&chi;", "U+03C7"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&psi;", "U+03C8"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&omega;", "U+03C9"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&thetasym;", "U+03D1"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&upsih;", "U+03D2"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&piv;", "U+03D6"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&ensp;", "U+2002"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&emsp;", "U+2003"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&thinsp;", "U+2009"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&zwnj;", "U+200C"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&zwj;", "U+200D"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&lrm;", "U+200E"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&rlm;", "U+200F"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&ndash;", "U+2013"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&mdash;", "U+2014"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&lsquo;", "U+2018"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&rsquo;", "U+2019"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sbquo;", "U+201A"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&ldquo;", "U+201C"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&rdquo;", "U+201D"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&bdquo;", "U+201E"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&dagger;", "U+2020"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Dagger;", "U+2021"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&bull;", "U+2022"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&hellip;", "U+2026"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&permil;", "U+2030"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&prime;", "U+2040"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&Prime;", "U+2033"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lsaquo;", "U+2039"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&rsaquo;", "U+203A"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&oline;", "U+203E"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&frasl;", "U+2044"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&euro;", "U+20AC"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&image;", "U+2111"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&weierp;", "U+2118"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&real;", "U+211C"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&trade;", "U+2122"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&alefsym;", "U+2135"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&larr;", "U+2190"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&uarr;", "U+2191"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&rarr;", "U+2192"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&darr;", "U+2193"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&harr;", "U+2194"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&crarr;", "U+21B5"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lArr;", "U+21D0"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&uArr;", "U+21D1"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&rArr;", "U+21D2"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&dArr;", "U+21D3"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&hArr;", "U+21D4"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&forall;", "U+2200"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&part;", "U+2202"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&exist;", "U+2203"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&empty;", "U+2205"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&nabla;", "U+2207"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&isin;", "U+2208"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&notin;", "U+2209"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&ni;", "U+220B"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&prod;", "U+220F"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&sum;", "U+2211"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&minus;", "U+2212"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lowast;", "U+2217"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&radic;", "U+221A"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&prop;", "U+221D"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&infin;", "U+221E"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&ang;", "U+2220"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&and;", "U+2227"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&or;", "U+2228"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&cap;", "U+2229"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&cup;", "U+222A"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&int;", "U+222B"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&there4;", "U+2234"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sim;", "U+223C"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&cong;", "U+2245"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&asymp;", "U+2248"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&ne;", "U+2260"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&equiv;", "U+2261"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&le;", "U+2264"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&ge;", "U+2265"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sub;", "U+2282"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sup;", "U+2283"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&nsub;", "U+2284"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sube;", "U+2286"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&supe;", "U+2287"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&oplus;", "U+2295"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&otimes;", "U+2297"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&perp;", "U+22A5"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&sdot;", "U+22C5"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&lceil;", "U+2308"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&rceil;", "U+2309"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lfloor;", "U+230A"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&rfloor;", "U+230B"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("&lang;", "U+2329"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&rang;", "U+232A"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&loz;", "U+25CA"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&spades;", "U+2660"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&clubs;", "U+2663"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&hearts;", "U+2665"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("&diams;", "U+2666"); //$NON-NLS-1$//$NON-NLS-2$

		xhtml10Map = new HashMap<String, String>();
		xhtml10Map.put("&apos;", "U+0027"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * Parses the given StringBuilder for appearances of known named html entity references, and replaces all such appearances with the appropriate character
	 * 
	 * @param htmlMap
	 *            The map of known named entity refs to apply. This depends on the HTML version
	 * @param stringBuilder
	 *            The string to parse for known html named entity references
	 * @return The same string object, with all appearances of known html named entity references replaced by the character those sequences stand for
	 */
	private static StringBuilder applyMap (HashMap<String, String> htmlMap, StringBuilder stringBuilder) {
		int p = 0;
		while (p < stringBuilder.length()) {
			if (stringBuilder.charAt(p) == '&') {
				boolean matched = false;
				Iterator<Map.Entry<String, String>> i_htmlMap = htmlMap.entrySet().iterator();
				while (i_htmlMap.hasNext() && !matched) {
					Map.Entry<String, String> me = i_htmlMap.next();
					String entityRefSyntax = me.getKey();
					String entityRefValue = me.getValue();
					if (stringBuilder.substring(p, p + entityRefSyntax.length()).equals(entityRefSyntax)) {
						// found an appearance of an entity ref - replace it.
						stringBuilder.replace(p, p + entityRefSyntax.length(), entityRefValue);
						matched = true;
					}
				}
			}
			p++;
		}

		return stringBuilder;
	}

	/**
	 * Parses the given StringBuilder for appearances of &#nnnn or &#xhhhh sequences, and replaces all such appearances with the appropriate character
	 * 
	 * @param string
	 *            The string to parse for html numeric escape sequences
	 * @return The same string object, with all appearances of html escape sequences replaced by the character those sequences stand for
	 */
	private static StringBuilder applyNumerals (StringBuilder string) {
		int p = 0;
		int sLength = string.length();
		while (p < sLength - 1) {
			if (string.charAt(p) == '&' && string.charAt(p + 1) == '#') {
				int e = p + 2;
				boolean hexmode;
				if (e < sLength && string.charAt(e) == 'x') {
					hexmode = true;
					e++;
				} else {
					hexmode = false;
				}
				StringBuilder numeral = new StringBuilder(16);
				while (e < sLength && string.charAt(e) != ';') {
					numeral.append(string.charAt(e++));
				}
				e++; // make sure we include the ; when replacing
				int number;
				if (hexmode) {
					number = Integer.parseInt(numeral.toString(), 16);
				} else {
					number = Integer.parseInt(numeral.toString());
				}

				if (Character.isValidCodePoint(number)) {
					// found an appearance of an entity ref - replace it.
					string.delete(p, e);
					string.insert(p, Character.valueOf((char) number));
				}
			}
			p++;
		}

		return string;
	}

	/**
	 * Processes the input string and replaces all appearances of entity references that are valid under the htmlVersion specified with their actual codepoint value.
	 * 
	 * @param string
	 *            The input string to be "sanitized" from &#nnnn and &#xhhhh appearances, as well as any named entity refs valid in the given html Version.
	 * @param htmlVersion
	 *            The version indicating which entity refs table to use
	 * @return The sanitized string
	 */
	public static String fromHtml (String string, Version htmlVersion) {
		if (htmlVersion.equals(FOUR_NIL)) {
			return applyMap(html40Map, new StringBuilder(fromHtml(string, THREE_TWO))).toString();
		}
		if (htmlVersion.equals(THREE_TWO)) {
			return applyMap(html32Map, new StringBuilder(fromHtml(string, TWO_NIL))).toString();
		}
		if (htmlVersion.equals(TWO_NIL)) {
			return applyMap(html20Map, applyNumerals(new StringBuilder(string))).toString();
		}

		return string;

	}

	/**
	 * Processes the input string and replaces all appearances of entity references that are valid under the htmlVersion specified with their actual codepoint value.
	 * 
	 * @param string
	 *            The input string to be "sanitized" from &#nnnn and &#xhhhh appearances, as well as any named entity refs valid in the given html Version.
	 * @param xhtmlVersion
	 *            The version indicating which entity refs table to use
	 * @return The sanitized string
	 */
	public static String fromXHtml (String string, Version xhtmlVersion) {
		if (xhtmlVersion.equals(Version.ONE_ZERO)) {
			return applyMap(xhtml10Map, new StringBuilder(fromHtml(string, FOUR_NIL))).toString();
		}

		return string;
	}

	/**
	 * Gets the XML version of the input string, i.e. with all <>'"& characters replaced by their appropriate entity references
	 * 
	 * @param string
	 *            the string to be rendered to valid xml
	 * @return the XML version of the input string, i.e. with all <>'"& characters replaced by their appropriate entity references
	 */
	public static String toXML (String string) {
		int length = string.length();
		StringBuilder w = new StringBuilder(length + length >>> 3);
		int i = 0;
		while (i < length) {
			char c = string.charAt(i++);
			switch (c) {
				case '<':
					w.append("&lt;"); //$NON-NLS-1$
					break;
				case '>':
					w.append("&gt;"); //$NON-NLS-1$
					break;
				case '&':
					w.append("&amp;"); //$NON-NLS-1$
					break;
				case '"':
					w.append("&quot;"); //$NON-NLS-1$
					break;
				case '\'':
					w.append("&apos;"); //$NON-NLS-1$
					break;
				default:
					w.append(c);
					break;
			}
		}
		return w.toString();
	}

	/**
	 * prevent instantiation
	 */
	private EntityRefs ( ) {

	}
}
