/*
 * Created on 26-jul-2008
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.messages.ServerErrorMessage;

/**
 * An ErrorMessageException is thrown to indicate that a received message is (presumably) not the expected type of message, but an error message instead. That way, the java Exceptions mechanism can be used to isolate exception processing in a SIRA_PRISE client for exceptions signaled by a SIRA_PRISE server, instead of having to code 'instanceof ErrorMessageType' in each and every client. The getMessage() method of this Exception will return a string structured as 'errortype:errornum:errortext', in which errortext is the original error message sent out by the server, and errortype:errornum can be as follows :
 * <table border="1" width="99%">
 * <th>
 * <td>Errortype</td>
 * <td>Errortype description</td>
 * <td>Meaning of ErrorNum</td></th>
 * <tr>
 * <td>201806116</td>
 * <td>Error indicates a constraint violation</td>
 * <td>The numeric Id of the constraint that was violated</td>
 * </tr>
 * <tr>
 * <td>858993459</td>
 * <td>Error indicates a runtime error</td>
 * <td>none, value always -1</td>
 * </tr>
 * <tr>
 * <td>1497858657</td>
 * <td>Error indicates a sira_prise runtime error</td>
 * <td>The numeric Id of the runtime error</td>
 * </tr>
 * </table>
 * 
 * @author Erwin Smout
 */
public class ErrorMessageException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8309171434888332876L;

	/**
	 * The error message that was read instead of the (presumably) expected one.
	 */
	private ServerErrorMessage serverErrorMessage;

	/**
	 * Creates the exception, setting the server error message that caused this exception to be thrown.
	 * 
	 * @param serverErrorMessage
	 *            The error message that was read instead of the (presumably) expected one.
	 */
	public ErrorMessageException (ServerErrorMessage serverErrorMessage) {
		super(Long.toString(serverErrorMessage.getMessageTypeID()) + ':' + Long.toString(serverErrorMessage.getErrorNumber()) + ':' + serverErrorMessage.getOriginalExceptionMessage());
		this.serverErrorMessage = serverErrorMessage;
	}

	/**
	 * Gets The error message that was read instead of the (presumably) expected one.
	 * 
	 * @return The error message that was read instead of the (presumably) expected one.
	 */
	public ServerErrorMessage getServerErrorMessage ( ) {
		return serverErrorMessage;
	}
}