/**
 * 
 */
package be.SIRAPRISE.client;

/**
 * The IDS interface encloses interfaces that define the constant values for all sorts of internal Id used in SIRA_PRISE
 * 
 * @author Erwin
 */
public interface IDS {

	/**
	 * @author Erwin
	 * 
	 */
	public interface KEYERRORCODES {

		/**
		 * ASSIGNMENTCONSTRAINT:{ERRORCODE}
		 */
		public static final int ASSIGNMENTCONSTRAINT = 246;

		/**
		 * 
		 */
		public static final int ASSIGNMENTCONSTRAINTCHECK = 260;

		/**
		 * ATTRIBUTE:{ATTRIBUTENAME}
		 */
		public static final int ATTRIBUTE = 202;

		/**
		 * ATTRIBUTELOGICALLENGTH:{ATTRIBUTENAME}
		 */
		public static final int ATTRIBUTELOGICALLENGTH = 286;

		/**
		 * ATTRIBUTEPHYSICALLENGTH:{ATTRIBUTENAME}
		 */
		public static final int ATTRIBUTEPHYSICALLENGTH = 296;

		/**
		 * 
		 */
		public static final int ATTRIBUTEVALUEDISTRIBUTION = 256;

		/**
		 * CLIENT:{CLIENT}
		 */
		public static final int CLIENT = 316;

		/**
		 * CLIENTCERTIFICATE:{CLIENT ALGORITHM}
		 */
		public static final int CLIENTCERTIFICATE = 310;

		/**
		 * CONSTRAINEDTYPE:{TYPENAME}
		 */
		public static final int CONSTRAINEDTYPE = 284;

		/**
		 * CONSTRAINTINVOLVESRELVAR:{RELVARNAME ERRORCODE}
		 */
		public static final int CONSTRAINTINVOLVESRELVAR = 324;

		/**
		 * CONSTRAINTMESSAGETEXT:{ERRORCODE}
		 */
		public static final int CONSTRAINTMESSAGETEXT = 268;

		/**
		 * CURRENTCONTEXT:{}
		 */
		public static final int CURRENTCONTEXT = 306;

		/**
		 * CURRENTDATE:{}
		 */
		public static final int CURRENTDATE = 204;

		/**
		 * CURRENTUPDATE:{}
		 */
		public static final int CURRENTUPDATE = 308;

		/**
		 * CURRENTUSER:{}
		 */
		public static final int CURRENTUSER = 298;

		/**
		 * DATABASECONSTRAINT:{ERRORCODE}
		 */
		public static final int DATABASECONSTRAINT = 208;

		/**
		 * DATABASECONSTRAINTCHECK:{RELVARNAME ERRORCODE OPERATIONTYPE}
		 */
		public static final int DATABASECONSTRAINTCHECK = 210;

		/**
		 * DATASPACE:{FILENAME STORAGESPACEID}
		 */
		public static final int DATASPACE = 212;

		/**
		 * DBMSFILE:{FILENAME}
		 */
		public static final int DBMSFILE = 214;

		/**
		 * 
		 */
		public static final int TABLE_DEE = 272;

		/**
		 * 
		 */
		public static final int TABLE_DUM = 270;

		/**
		 * 
		 */
		public static final int HASHINGINDEXSPACE = 218;

		/**
		 * INDEX:{INDEXNAME RELVARNAME}
		 */
		public static final int INDEX = 220;

		/**
		 * 
		 */
		public static final int INDEXATTRIBUTE = 224;

		/**
		 * 
		 */
		public static final int INDEXCOMPONENT = 274;

		/**
		 * INDEXID:{INDEXNAME RELVARNAME}
		 */
		public static final int INDEXID = 276;

		/**
		 * 
		 */
		public static final int INDEXID_ID = 278;

		/**
		 * INTERVALTYPE:{INTERVALTYPENAME}
		 */
		public static final int INTERVALTYPE = 226;

		/**
		 * INTERVALTYPE:{TYPENAME}
		 */
		public final static int INTERVALTYPE_SOURCE = 228;

		/**
		 * 
		 */
		public static final int KEY = 230;

		/**
		 * 
		 */
		public static final int KEYATTRIBUTE = 232;

		/**
		 * 
		 */
		public static final int MULTIHASHINGINDEXSPACE = 280;

		/**
		 * 
		 */
		public static final int NEWATTRIBUTEDEFAULTVALUE = 248;

		/**
		 * 
		 */
		public static final int POSSREP = 240;

		/**
		 * 
		 */
		public static final int POSSREPCOMPONENT = 242;

		/**
		 * 
		 */
		public static final int RECORDATTRIBUTE = 244;

		/**
		 * The internal ID for the 'ordinal' key
		 */
		public final static int RECORDATTRIBUTE_ORD = 246;

		/**
		 * 
		 */
		public static final int RECORDTYPE = 288;

		/**
		 * 
		 */
		public static final int RECORDTYPE_LOCATORINDEXNAME = 236;

		/**
		 * 
		 */
		public static final int RECORDTYPEID = 292;

		/**
		 * 
		 */
		public static final int RECORDTYPEID_ID = 294;

		/**
		 * 
		 */
		public static final int RELVAR = 250;

		/**
		 * 
		 */
		public static final int RELVARATTRIBUTE = 252;

		/**
		 * 
		 */
		public static final int RELVARCARDINALITY = 216;

		/**
		 * The internal id of the key on the relvarname attribute
		 */
		public final static int RELVARID_NAME = 256;

		/**
		 * 
		 */
		public static final int RELVARID = 254;

		/**
		 * 
		 */
		public static final int STORAGESPACE = 258;

		/**
		 * 
		 */
		public static final int STORAGESPACEEXTENTS = 228;

		/**
		 * 
		 */
		public static final int SYSTEMDEFINEDCLIENT = 318;

		/**
		 * 
		 */
		public static final int SYSTEMDEFINEDCONSTRAINT = 304;

		/**
		 * 
		 */
		public static final int SYSTEMDEFINEDRELVAR = 302;

		/**
		 * 
		 */
		public static final int SYSTEMDEFINEDTYPE = 294;

		/**
		 * 
		 */
		public static final int SYSTEMDEFINEDUSER = 320;

		/**
		 * 
		 */
		public static final int TREEINDEXSPACE = 262;

		/**
		 * 
		 */
		public static final int TRIGGEREDDATAACTION = 342;

		/**
		 * 
		 */
		public static final int DATAACTIONREFERENCES = 344;

		/**
		 * 
		 */
		public static final int TUPLECONSTRAINT = 206;

		/**
		 * 
		 */
		public static final int TUPLECONSTRAINTATTRIBUTE = 282;

		/**
		 * 
		 */
		public static final int TUPLEINDEX = 290;

		/**
		 * 
		 */
		public static final int TYPE = 264;

		/**
		 * 
		 */
		public static final int TYPEPROPERTIES = 266;

		/**
		 * 
		 */
		public static final int UDTORDERINGOPERATOR = 338;

		/**
		 * 
		 */
		public static final int UDTPHYSICALPOSSREPCOMPONENTORDINAL = 336;

		/**
		 * 
		 */
		public static final int UDTPHYSICALPOSSREPCOMPONENT = 334;

		/**
		 * 
		 */
		public static final int UDTPOSSREP = 330;

		/**
		 * 
		 */
		public static final int UDTPOSSREPCOMPONENT = 332;

		/**
		 * 
		 */
		public static final int UDTPPCVALUESELECTOR = 340;

		/**
		 * 
		 */
		public static final int USER = 314;

		/**
		 * 
		 */
		public static final int USERCERTIFICATE = 312;

		/**
		 * 
		 */
		public static final int USERDEFINEDTYPE = 328;

		/**
		 * 
		 */
		public static final int VIRTUALRELVAR = 238;

		/**
		 * 
		 */
		public static final int VIRTUALRELVARREFERENCES = 322;

	}

	/**
	 * @author Erwin Smout
	 */
	public interface ERRORCODES {

		/**
		 * Comment for <code>ASSIGNMENTCONSTRAINTINVOCATIONASSIGNMENTCONSTRAINT</code>
		 */
		public static final long ASSIGNMENTCONSTRAINTINVOCATIONASSIGNMENTCONSTRAINT = 126;

		/**
		 * Comment for <code>ASSIGNMENTCONSTRAINTINVOCATIONRELVAR</code>
		 */
		public static final long ASSIGNMENTCONSTRAINTINVOCATIONRELVAR = 125;

		/**
		 * Comment for <code>ASSIGNMENTCONSTRAINTOTHERCONSTRAINT</code>
		 */
		public static final long ASSIGNMENTCONSTRAINTOTHERCONSTRAINT = 127;

		/**
		 * Comment for <code>ATTRIBUTEATTRIBUTEPHYSICALLENGTH</code>
		 */
		public static final long ATTRIBUTEATTRIBUTEPHYSICALLENGTH = 86;

		/**
		 * @deprecated
		 */
		public static final long ATTRIBUTECONSTRAINEDTYPESIZE = 71;

		/**
		 * Comment for <code>ATTRIBUTELOGICALLENGTHATTRIBUTE</code>
		 */
		public static final long ATTRIBUTELOGICALLENGTHATTRIBUTE = 74;

		/**
		 * Comment for <code>ATTRIBUTEPHYSICALLENGTHATTRIBUTE</code>
		 */
		public static final long ATTRIBUTEPHYSICALLENGTHATTRIBUTE = 87;

		/**
		 * "An attribute and a possrep have the same name"
		 */
		// public static final long ATTRIBUTEPOSSREPSHARENAME = 1;
		/**
		 * "An attribute's internal length is outside the range of the type's size"
		 */
		public static final long ATTRIBUTESIZE = 40;

		/**
		 * Comment for <code>ATTRIBUTESIZEMISSING</code>
		 */
		public static final long ATTRIBUTESIZEMISSING = 72;

		/**
		 * "An Attribute refers to a non-existing Type"
		 */
		public static final long ATTRIBUTETYPE = 2;

		/**
		 * Comment for <code>ATTRIBUTEVALUEDISTRIBUTIONINDEXATTRIBUTE</code>
		 */
		public static final long ATTRIBUTEVALUEDISTRIBUTIONINDEXATTRIBUTE = 89;

		/**
		 * Comment for <code>CLIENTCERTIFICATECLIENT</code>
		 */
		public static final long CLIENTCERTIFICATECLIENT = 96;

		/**
		 * Comment for <code>CLIENTSYSTEMDEFINEDCLIENT</code>
		 */
		public static final long CLIENTSYSTEMDEFINEDCLIENT = 95;

		/**
		 * Comment for <code>CONSTRAINEDTYPETYPE</code>
		 */
		public static final long CONSTRAINEDTYPEANDTYPE = 69;

		/**
		 * Comment for <code>CONSTRAINEDTYPETYPE</code>
		 */
		public static final long CONSTRAINEDTYPETYPE = 70;

		/**
		 * 
		 */
		public static final long CONSTRAINTINVOLVESRELVARASSIGNMENTCONSTRAINT = 141;

		/**
		 * 
		 */
		public static final long CONSTRAINTINVOLVESRELVARRELVARS = 140;

		/**
		 * Comment for <code>CONSTRAINTMESSAGETEXTCONSTRAINT</code>
		 */
		public static final long CONSTRAINTMESSAGETEXTCONSTRAINT = 44;

		/**
		 * @deprecated
		 */
		public static final long D_TYPEINTERVALTYPE = 128;

		/**
		 * "A Constraint check refers to a non-existing constraint"
		 */
		public static final long DATABASECONSTRAINTINVOCATIONDATABASECONSTRAINT = 3;

		/**
		 * "A Constraint check refers to a non-existing Relvar"
		 */
		public static final long DATABASECONSTRAINTINVOCATIONRELATION = 5;

		/**
		 * @deprecated
		 */
		public static final long DATABASECONSTRAINTTRANSACTIONCONSTRAINT = 91;

		/**
		 * Comment for <code>CONSTRAINTSERRORCODE</code>
		 */
		public static final long DATABASECONSTRAINTTUPLECONSTRAINT = 43;

		/**
		 * Comment for <code>DATASPACECOMPRESSIONTHRESHOLD</code>
		 */
		public static final long DATASPACECOMPRESSIONTHRESHOLD = 47;

		/**
		 * Comment for <code>DATASPACEMAXIMUMGAPS</code>
		 */
		public static final long DATASPACEMAXIMUMGAPS = 48;

		/**
		 * "A DataSpace refers to a non-existing StorageSpace"
		 */
		public static final long DATASPACESTORAGESPACE = 4;

		/**
		 * "Page size must be > 2047 and < 65537"
		 */
		public static final long DBMSFILEPAGESIZE = 6;

		/**
		 * "A StorageSpace refers to a non-existing DbmsFile"
		 */
		public static final long DBMSFILESTORAGESPACE = 7;

		/**
		 * Comment for <code>EXTENTSCOUNT</code>
		 */
		public static final long EXTENTSCOUNT = 101;

		/**
		 * "A hashingindex is not defined as an index"
		 */
		// public static final long HASHINGINDEXINDEX = 10;
		/**
		 * "A HashingindexSpace refers to a non-existing StorageSpace"
		 */
		public static final long HASHINGINDEXSPACESTORAGESPACE = 8;

		/**
		 * Comment for <code>I_D_UPDATECONSTRAINTCHECK</code>
		 */
		public static final long I_D_ASSIGNMENTCONSTRAINTCHECK = 124;

		/**
		 * Comment for <code>I_D_ATTRIBUTEPHYSICALLENGTH</code>
		 */
		public static final long I_D_ATTRIBUTEPHYSICALLENGTH = 108;

		/**
		 * 
		 */
		public static final long I_D_CONSTRAINTINVOLVESRELVAR = 142;

		/**
		 * Comment for <code>I_D_DATABASECONSTRAINTCHECK</code>
		 */
		public static final long I_D_DATABASECONSTRAINTCHECK = 109;

		/**
		 * Comment for <code>I_D_INDEXATTRIBUTE</code>
		 */
		public static final long I_D_INDEXATTRIBUTE = 112;

		/**
		 * Comment for <code>I_D_INDEXID</code>
		 */
		public static final long I_D_INDEXID = 113;

		/**
		 * Comment for <code>I_D_INTERVALTYPE</code>
		 */
		public static final long I_D_INTERVALTYPE = 114;

		/**
		 * Comment for <code>I_D_POSSREP</code>
		 */
		public static final long I_D_POSSREP = 115;

		/**
		 * Comment for <code>I_D_POSSREPCOMPONENT</code>
		 */
		public static final long I_D_POSSREPCOMPONENT = 116;

		/**
		 * Comment for <code>I_D_RECORDTYPEID</code>
		 */
		public static final long I_D_RECORDTYPEID = 117;

		/**
		 * Comment for <code>I_D_RELVARID</code>
		 */
		public static final long I_D_RELVARID = 118;

		/**
		 * Comment for <code>I_D_SYSTEMDEFINEDCLIENT</code>
		 */
		public static final long I_D_SYSTEMDEFINEDCLIENT = 119;

		/**
		 * Comment for <code>I_D_SYSTEMDEFINEDCONSTRAINT</code>
		 */
		public static final long I_D_SYSTEMDEFINEDCONSTRAINT = 135;

		/**
		 * Comment for <code>I_D_SYSTEMDEFINEDRELVAR</code>
		 */
		public static final long I_D_SYSTEMDEFINEDRELVAR = 132;

		/**
		 * Comment for <code>I_D_SYSTEMDEFINEDTYPE</code>
		 */
		public static final long I_D_SYSTEMDEFINEDTYPE = 120;

		/**
		 * Comment for <code>I_D_SYSTEMDEFINEDUSER</code>
		 */
		public static final long I_D_SYSTEMDEFINEDUSER = 121;

		/**
		 * Comment for <code>I_D_TABLE_DEE</code>
		 */
		public static final long I_D_TABLE_DEE = 110;

		/**
		 * Comment for <code>I_D_TABLE_DUM</code>
		 */
		public static final long I_D_TABLE_DUM = 111;

		/**
		 * 
		 */
		public static final long I_D_TRIGGEREDDATAACTION = 158;

		/**
		 * @deprecated
		 */
		public static final long I_D_TUPLECONSTRAINTATTRIBUTE = 122;

		/**
		 * Comment for <code>I_D_TYPEPROPERTIES</code>
		 */
		public static final long I_D_TYPEPROPERTIES = 123;

		/**
		 * Comment for <code>I_SYSTEMDEFINEDCONSTRAINT</code>
		 */
		public static final long I_SYSTEMDEFINEDCONSTRAINT = 137;

		/**
		 * "An Index Attribute refers to a non-existing Index"
		 */
		public static final long INDEXATTRIBUTEINDEXCOMPONENT = 9;

		/**
		 * "An Index Attribute refers to a non-existing Record Attribute"
		 */
		public static final long INDEXATTRIBUTERECORDATTRIBUTE = 14;

		/**
		 * The sequence number of an index attribute must be strictly positive
		 */
		// public static final long ORDINAL = 57;
		/**
		 * All indexcomponents must be components for an existing index
		 */
		public static final long INDEXCOMPONENTINDEX = 60;

		/**
		 * "The ordinal of an indexcomponent must be > 0"
		 */
		public static final long INDEXCOMPONENTORDINAL = 59;

		/**
		 * Comment for <code>INDEXIDINDEX</code>
		 */
		public static final long INDEXIDINDEX = 63;

		/**
		 * Comment for <code>INDEXINDEXID</code>
		 */
		public static final long INDEXINDEXID = 62;

		/**
		 * "An index is specified to be both a hashing and a locator index"
		 */
		// public static final long INDEXBOTHLOCATORANDHASH = 12;
		/**
		 * "An index is specified to be both a hashing and a tree index."
		 */
		// public static final long INDEXBOTHTREEANDHASH = 51;
		/**
		 * "An index is specified to be both a locator and a tree index."
		 */
		// public static final long INDEXBOTHTREEANDLOCATOR = 52;
		/**
		 * "An index refers to a non-existing Index Space"
		 */
		public static final long INDEXINDEXSPACE = 11;

		/**
		 * Single index spaces can contain only one index
		 */
		public static final long INDEXINSINGLEINDEXSPACEUNIQUE = 67;

		/**
		 * An index is defined on a relvar that is not recorded
		 */
		public static final long INDEXRECORDTYPE = 56;

		/**
		 * No intervaltyped attribute can be a determinant in a component of a locator index
		 */
		public static final long INTERVALLOCATORCOMPONENT = 61;

		/**
		 * "An index is not specified to be hashing or locator"
		 */
		// public static final long INDEXTYPEUNSPECIFIED = 13;
		/**
		 * "An interval Type refers to a non-existing Base Type"
		 */
		public static final long INTERVALTYPEBASETYPE = 15;

		/**
		 * "An interval Type is itself not registered as a Type"
		 */
		public static final long INTERVALTYPETYPE = 16;

		/**
		 * "A Key Attribute refers to a non-existing Key"
		 */
		public static final long KEYATTRIBUTEKEY = 17;

		/**
		 * "A Key Attribute refers to a non-existing Relvar Attribute"
		 */
		public static final long KEYATTRIBUTERELVARATTRIBUTE = 24;

		/**
		 * "A Key refers to a non-existing Relvar"
		 */
		public static final long KEYRELVAR = 21;

		/**
		 * Comment for <code>DATASPACECOMPRESSIONTHRESHOLD</code>
		 */
		public static final long MULTIHASHINGINDEXSPACECOMPRESSIONTHRESHOLD = 81;

		/**
		 * Comment for <code>DATASPACEMAXIMUMGAPS</code>
		 */
		public static final long MULTIHASHINGINDEXSPACEMAXIMUMGAPS = 82;

		/**
		 * Comment for <code>MULTIHASHINGINDEXSPACESTORAGESPACE</code>
		 */
		public static final long MULTIHASHINGINDEXSPACESTORAGESPACE = 73;

		/**
		 * "A default value for a record attribute refers to a non-existing record attribute"
		 */
		public static final long NEWATTRIBUTEDEFAULTVALUE = 26;

		/**
		 * Comment for <code>NONEMPTYDATASPACEEXTENTSDELETE</code>
		 */
//		public static final long NONEMPTYDATASPACEEXTENTSDELETE = 98;

		/**
		 * "An attempt was made to change the number of allowed extents for storage space STORAGESPACEID in dbms file FILENAME, which is still used for recording record type RECORDTYPENAME of relvar RELVARNAME."
		 */
		public static final long STORAGESPACESIZEUPDATEWHILEINUSE = 97;

		/**
		 * Comment for <code>NONEMPTYINDEXSPACEEXTENTSINSERT</code>
		 */
//		public static final long NONEMPTYINDEXSPACEEXTENTSINSERT = 99;

		/**
		 * Comment for <code>NONEMPTYINNDEXSPACEEXTENTSDELETE</code>
		 */
//		public static final long NONEMPTYINNDEXSPACEEXTENTSDELETE = 100;

		/**
		 * "A possrep component refers to a non-existing possrep"
		 */
		public static final long POSSREPCOMPONENTPOSSREP = 20;

		/**
		 * "A possrep component type refers to a non-existing type"
		 */
		public static final long POSSREPCOMPONENTTYPE = 22;

		/**
		 * Comment for <code>POSSREPCOMPONENTTYPENAMES</code>
		 */
		public static final long POSSREPCOMPONENTTYPENAMES = 23;

		/**
		 * "A Possible representation refers to a non-existing Type"
		 */
		public static final long POSSREPTYPE = 25;

		/**
		 * "A Record attribute refers to a non-existing Relvar Attribute"
		 */
		public static final long RECORDATTRIBUTERELVARATTRIBUTE = 27;

		/**
		 * Comment for <code>RECORDSIZEPAGESIZE</code>
		 */
		public static final long RECORDSIZEPAGESIZE = 85;

		/**
		 * Comment for <code>RECORDATTRIBUTERELVARLOCATION</code>
		 */
		// public static final long RECORDATTRIBUTERELVARLOCATION = 58;
		/**
		 * "A Relvar Location refers to a non-existing Data Space"
		 */
		public static final long RECORDTYPEDATASPACE = 33;

		/**
		 * Comment for <code>RECORDTYPEIDRECORDTYPE</code>
		 */
		public static final long RECORDTYPEIDRECORDTYPE = 80;

		/**
		 * "A locator index is not defined as an index"
		 */
		public static final long RECORDTYPEINDEX = 19;

		/**
		 * Comment for <code>RECORDTYPERECORDTYPEID</code>
		 */
		public static final long RECORDTYPERECORDTYPEID = 79;

		/**
		 * "A RecordLocation refers to a non-existing Relvar"
		 */
		public static final long RECORDTYPERELVAR = 36;

		/**
		 * "A Relvar Attribute refers to a non-existing Attribute"
		 */
		public static final long RELVARATTRIBUTEATTRIBUTE = 28;

		/**
		 * "A Relvar Attribute refers to a non-existing Relvar"
		 */
		public static final long RELVARATTRIBUTERELVAR = 29;

		/**
		 * Comment for <code>RELVARDARDINALITYRECORDTYPE</code>
		 */
		public static final long RELVARDARDINALITYRECORDTYPE = 88;

		/**
		 * "A Relvar Attribute does not occur in the record of a Relvar"
		 */
		// public static final long RELVARATTRIBUTEUNRECORDED = 32;
		/**
		 * "A RelvarID refers to a non-existing Relvar"
		 */
		public static final long RELVARIDRELVAR = 31;

		/**
		 * "A Relvar has no Key"
		 */
		public static final long RELVARKEY = 34;

		/**
		 * Comment for <code>RELVARVIRTUALRELVAR</code>
		 */
		public static final long RELVARVIRTUALRELVAR = 103;

		/**
		 * Comment for <code>RELVARPOSSREPSHARENAME</code>
		 */
		// public static final long RELVARPOSSREPSHARENAME = 83;
		/**
		 * @deprecated 
		 */
//		public static final long RELVARWITHOUTID = 35;

		/**
		 * "A Storage space is defined to be both a hashing index space and a data space"
		 */
		public static final long STORAGESPACEBOTHHASHANDDATA = 54;

		/**
		 * Comment for <code>STORAGESPACEBOTHHASHANDMULTIHASH</code>
		 */
		public static final long STORAGESPACEBOTHHASHANDMULTIHASH = 66;

		/**
		 * "A Storage space is defined to be both a hashing index space and a tree index space"
		 */
		public static final long STORAGESPACEBOTHHASHANDTREE = 53;

		/**
		 * Comment for <code>STORAGESPACEBOTHMULTIHASHANDDATA</code>
		 */
		public static final long STORAGESPACEBOTHMULTIHASHANDDATA = 65;

		/**
		 * Comment for <code>STORAGESPACEBOTHMULTIHASHANDTREE</code>
		 */
		public static final long STORAGESPACEBOTHMULTIHASHANDTREE = 64;

		/**
		 * "A Storage space is defined to be both a tree index space and a data space"
		 */
		public static final long STORAGESPACEBOTHTREEANDDATA = 55;

		/**
		 * Comment for <code>STORAGESPACEEXTENTSTORAGESPACE</code>
		 */
		public static final long STORAGESPACEEXTENTSTORAGESPACE = 102;

		/**
		 * Comment for <code>STORAGESPACEID</code>
		 */
		public static final long STORAGESPACEID = 46;

		/**
		 * Comment for <code>STORAGESPACEPAGECOUNT</code>
		 */
		public static final long STORAGESPACEPAGECOUNT = 45;

		/**
		 * "A StorageSpace has no corresponding Data or Index Space"
		 */
		public static final long STORAGESPACETYPEUNSPECIFIED = 37;

		/**
		 * Comment for <code>SYSTEMDEFINEDCONSTRAINTCONSTRAINTRELVAR</code>
		 */
		public static final long SYSTEMDEFINEDCONSTRAINTCONSTRAINTS = 134;

		/**
		 * Comment for <code>SYSTEMDEFINEDRELVARRELVARVIRTUALRELVAR</code>
		 */
		public static final long SYSTEMDEFINEDRELVARRELVARVIRTUALRELVAR = 131;

		/**
		 * Comment for <code>SYSTEMDEFINEDTYPETYPE</code>
		 */
		public static final long SYSTEMDEFINEDTYPETYPE = 84;

		/**
		 * Comment for <code>TRANSACTIONCONSTRAINTATTRIBUTERELVARATTRIBUTE</code>
		 */
		// public static final long TRANSACTIONCONSTRAINTATTRIBUTERELVARATTRIBUTE = 93;
		/**
		 * @deprecated
		 */
		public static final long TRANSACTIONCONSTRAINTRELVAR = 92;

		/**
		 * 
		 */
		public static final long KEYTUPLECONSTRAINT = 90;

		/**
		 * "A treeindex refers to a non-existing index."
		 */
		// public static final long TREEINDEXINDEX = 50;
		/**
		 * "A treeindexspace refers to a non-existing storage space."
		 */
		public static final long TREEINDEXSPACESTORAGESPACE = 49;

		/**
		 * Comment for <code>TRIGGEREDDATAACTIONCIRCULAR</code>
		 */
		// public static final long TRIGGEREDDATAACTIONCIRCULAR = 107;
		/**
		 * Comment for <code>TRIGGEREDDATAACTIONOPERATIONTYPE</code>
		 */
		public static final long TRIGGEREDDATAACTIONOPERATIONTYPE = 104;

		/**
		 * Comment for <code>TRIGGEREDDATAACTIONRELVAR1</code>
		 */
		public static final long TRIGGEREDDATAACTIONRELVAR1 = 105;

		/**
		 * Comment for <code>TRIGGEREDDATAACTIONRELVAR2</code>
		 */
		public static final long TRIGGEREDDATAACTIONRELVAR2 = 106;

		/**
		 * @deprecated
		 */
		public static final long TUPLECONSTRAINTATTRIBUTERELVARATTRIBUTE = 68;

		/**
		 * "A Relvar Constraint refers to a non-existing Relvar"
		 */
		public static final long TUPLECONSTRAINTRELVAR = 30;

		/**
		 * Comment for <code>TUPLEINDEXINDEX</code>
		 */
		public static final long TUPLEINDEXINDEX = 75;

		/**
		 * Comment for <code>TUPLEINDEXREQUIREDFORMULTIRECORDRELVARS</code>
		 */
		public static final long TUPLEINDEXREQUIREDFORMULTIRECORDRELVARS = 77;

		/**
		 * Comment for <code>TUPLEINDEXWITHCOMPONENTS</code>
		 */
		public static final long TUPLEINDEXWITHCOMPONENTS = 78;

		/**
		 * "A Type has no PossRep"
		 */
		public static final long TYPEPOSSREP = 38;

		/**
		 * Comment for <code>TYPEPROPERTIESTYPE</code>
		 */
		public static final long TYPEPROPERTIESTYPE = 41;

		/**
		 * Comment for <code>TYPETYPEPROPERTIES</code>
		 */
		public static final long TYPETYPEPROPERTIES = 42;

		/**
		 * Comment for <code>U_ATTRIBUTE</code>
		 */
		public static final long U_ATTRIBUTE = 129;

		/**
		 * Comment for <code>U_CONSTRAINEDTYPE</code>
		 */
		public static final long U_CONSTRAINEDTYPE = 130;

		/**
		 * 
		 */
		public static final long U_CONSTRAINEDTYPE_2 = 156;

		/**
		 * Comment for <code>U_SYSTEMDEFINEDCONSTRAINT</code>
		 */
		public static final long U_SYSTEMDEFINEDCONSTRAINT = 136;

		/**
		 * Comment for <code>U_SYSTEMDEFINEDRELVAR</code>
		 */
		public static final long U_SYSTEMDEFINEDRELVAR = 133;

		/**
		 * 
		 */
		public static final long U_USERDEFINEDTYPE = 157;

		/**
		 * 
		 */
		public static final long UDTORDERINGOPERATORUSERDEFINEDTYPE = 150;

		/**
		 * 
		 */
		public static final long UDTPHYSICALPOSSREPCOMPONENTTYPENAMES = 146;

		/**
		 * 
		 */
		public static final long UDTPHYSICALPOSSREPCOMPONENTTYPEPROPERTIES = 155;

		/**
		 * 
		 */
		public static final long UDTPHYSICALPOSSREPCOMPONENTTYPES = 151;

		/**
		 * 
		 */
		public static final long UDTPHYSICALPOSSREPCOMPONENTUSERDEFINEDTYPE = 147;

		/**
		 * 
		 */
		public static final long UDTPOSSREPCOMPONENTUDTPHYSICALPOSSREPCOMPONENT = 149;

		/**
		 * 
		 */
		public static final long UDTPOSSREPCOMPONENTUDTPOSSREP = 148;

		/**
		 * 
		 */
		public static final long UDTPOSSREPUSERDEFINEDTYPE = 145;

		/**
		 * 
		 */
		public static final long UDTPPCVALUESELECTORSCOMPLETEPERPOSSREP = 154;

		/**
		 * 
		 */
		public static final long UDTPPCVALUESELECTORUDTPHYSICALPOSSREPCOMPONENT = 153;

		/**
		 * 
		 */
		public static final long UDTPPCVALUESELECTORUDTPOSSREP = 152;

		/**
		 * @deprecated - keys correspond one on one to their own error code
		 */
		public static final long UNIQUEKEY = 39;

		/**
		 * Comment for <code>USERCERTIFICATEUSER</code>
		 */
		public static final long USERCERTIFICATEUSER = 94;

		/**
		 * 
		 */
		public static final long USERDEFINEDTYPETYPES = 143;

		/**
		 * 
		 */
		public static final long USERDEFINEDTYPEUDTPOSSREP = 144;

		/**
		 * Comment for <code>USERSYSTEMDEFINEDUSER</code>
		 */
		public static final long USERSYSTEMDEFINEDUSER = 93;

		/**
		 * 
		 */
		public static final long VIRTUALRELVARREFERENCESRELVAR = 139;

		/**
		 * 
		 */
		public static final long VIRTUALRELVARREFERENCESVIRTUALRELVAR = 138;

		/**
		 * 
		 */
		public static final long I_D_DATAACTIONREFERENCES = 159;

		/**
		 * 
		 */
		public static final long I_D_VIRTUALRELVARREFERENCES = 160;

		/**
		 * 
		 */
		public static final long I_TYPESNAMEDINTERVAL = 161;

		/**
		 * 
		 */
		public static final long UDTTYPENAMECOMPONENTNAME = 162;

		/**
		 * 
		 */
		public static final long POSSREPCOMPONENTTYPENAMECOMPONENTNAME = 163;

		/**
		 * 
		 */
		public static final long I_VIRTUALRELVAR = 164;

		/**
		 * 
		 */
		public static final long DBMSFILEPAGERESIZE = 165;

		/**
		 * 
		 */
		public static final long I_TRIGGEREDDATAACTION = 166;

		/**
		 * 
		 */
		public static final long I_TUPLECONSTRAINT = 167;

	}

	/**
	 * The INDEXIDS interface contains the values for the internal ID of all catalog indexes whose ID differs from the concerned relvar's ID plus one. These are additional indexes on the relvar's record besides the required locator index.
	 * 
	 * @author Erwin
	 */
	public interface INDEXIDS {

		/**
		 * The internal ID for the componentTypeName index
		 */
		public static final int COMPONENTTYPENAME = 44;

		/**
		 * 
		 */
		public static final long UDTPHYSICALCOMPONENTTYPENAME = 136;

		/**
		 * 
		 */
		public static final long TRIGGEREDDATAACTION_ACTIONNAME = 146;

		/**
		 * 
		 */
		public static final long RECORDTYPE_DATASPACE = 34;

		/**
		 * 
		 */
		public static final long INDEXID_ID = 78;

		/**
		 * 
		 */
		public static final long RECORDTYPEID_ID = 94;

		/**
		 * 
		 */
		public static final long KEY = 30;

		/**
		 * 
		 */
		public static final long KEYATTRIBUTE = 32;

	}

	/**
	 * The RELVARIDS interface contains the values for the internal ID of all system-defined relvars used in SIRA_PRISE
	 * 
	 * @author Erwin
	 */
	public interface RELVARIDS {

		/**
		 * The internal numeric ID of the Relvar
		 */
		public final static int ASSIGNMENTCONSTRAINT = 46;

		/**
		 * The internal ID for this relvar
		 */
		public final static int ASSIGNMENTCONSTRAINTCHECK = 60;

		/**
		 * The internal ID for the ATTRIBUTE relvar
		 */
		public final static int ATTRIBUTE = 2;

		/**
		 * The internal ID of this relvar
		 */
		public static final int ATTRIBUTELOGICALLENGTH = 86;

		/**
		 * The internal ID of the relvar
		 */
		public static final int ATTRIBUTEPHYSICALLENGTH = 96;

		/**
		 * Comment for <code>ATTRIBUTEVALUEDISTRIBUTION</code>
		 */
		public static final int ATTRIBUTEVALUEDISTRIBUTION = 56;

		/**
		 * The numeric ID of the relvar
		 */
		public static final int CLIENT = 116;

		/**
		 * The numeric ID of the relvar
		 */
		public static final int CLIENTCERTIFICATE = 110;

		/**
		 * The internal ID of the relvar
		 */
		public static final int CONSTRAINEDTYPE = 84;

		/**
		 * 
		 */
		public static final int CONSTRAINTINVOLVESRELVAR = 124;

		/**
		 * The internal ID for this relvar
		 */
		public final static int CONSTRAINTMESSAGETEXT = 68;

		/**
		 * The numeric ID
		 */
		public static final int CURRENTCONTEXT = 106;

		/**
		 * The numeric ID
		 */
		public static final int CURRENTDATE = 4;

		/**
		 * The internal numeric ID
		 */
		public static final int CURRENTUPDATE = 108;

		/**
		 * The numeric ID of this relvar
		 */
		public static final int CURRENTUSER = 98;

		/**
		 * 
		 */
		public static final int DATAACTIONREFERENCES = 144;

		/**
		 * The internal numeric ID of the Relvar
		 */
		public final static int DATABASECONSTRAINT = 8;

		/**
		 * The internal ID for this relvar
		 */
		public final static int DATABASECONSTRAINTCHECK = 10;

		/**
		 * The internal ID of the dataspace relvar
		 */
		public final static int DATASPACE = 12;

		/**
		 * The internal numeric ID of the relvar
		 */
		public final static int DBMSFILE = 14;

		/**
		 * The internal ID of the relvar
		 */
		public final static int HASHINGINDEXSPACE = 18;

		/**
		 * The internal ID for the index relvar
		 */
		public final static int INDEX = 20;

		/**
		 * The internal ID of the IndexAttribute relvar
		 */
		public final static int INDEXATTRIBUTE = 24;

		/**
		 * The numeric id of the indexcomponent relvar
		 */
		public static final int INDEXCOMPONENT = 74;

		/**
		 * The internal ID of the relvar
		 */
		public static final int INDEXID = 76;

		/**
		 * The internal ID of the IntervalType relvar
		 */
		public final static int INTERVALTYPE = 26;

		/**
		 * The internal ID of the relvar
		 */
		public final static int KEY = 30;

		/**
		 * The internal ID of the relvar
		 */
		public final static int KEYATTRIBUTE = 32;

		/**
		 * The internal ID of the relvar
		 */
		public static final int MULTIHASHINGINDEXSPACE = 80;

		/**
		 * The numeric ID of the relvar
		 */
		public final static int NEWATTRIBUTEDEFAULTVALUE = 48;

		/**
		 * The internal ID for the possrep relvar
		 */
		public final static int POSSREP = 40;

		/**
		 * the internal ID for the relvar
		 */
		public final static int POSSREPCOMPONENT = 42;

		/**
		 * the internal ID for the relvar
		 */
		public final static int RECORDATTRIBUTE = 44;

		/**
		 * The numeric identification of this SysRelvar
		 */
		public static final int RECORDTYPE = 88;

		/**
		 * The internal ID of the recordtypeID relvar
		 */
		public static final int RECORDTYPEID = 92;

		/**
		 * The internal ID for the RELVAR System relvar
		 */
		public final static int RELVAR = 50;

		/**
		 * The internal id for the relvarattribute relvar
		 */
		public final static int RELVARATTRIBUTE = 52;

		/**
		 * Comment for <code>RELVARCARDINALITY</code>
		 */
		public static final int RELVARCARDINALITY = 16;

		/**
		 * The internal ID of the relvar
		 */
		public final static int RELVARID = 54;

		/**
		 * The numeric ID
		 */
		public final static int STORAGESPACE = 58;

		/**
		 * The numeric ID
		 */
		public final static int STORAGESPACEEXTENTS = 28;

		/**
		 * The numeric ID of the relvar
		 */
		public static final int SYSTEMDEFINEDCLIENT = 118;

		/**
		 * The internal ID for this relvar
		 */
		public static final int SYSTEMDEFINEDCONSTRAINT = 104;

		/**
		 * The internal ID for this relvar
		 */
		public static final int SYSTEMDEFINEDRELVAR = 102;

		/**
		 * The internal ID for this relvar
		 */
		public static final int SYSTEMDEFINEDTYPE = 94;

		/**
		 * Comment for <code>USER</code>
		 */
		public static final int SYSTEMDEFINEDUSER = 120;

		/**
		 * The internal ID for the TABLE_DEE rel"var"
		 */
		public final static int TABLE_DEE = 72;

		/**
		 * The internal ID for the TABLE_DUM rel"var"
		 */
		public final static int TABLE_DUM = 70;

		/**
		 * The internal numeric ID of the Relvar
		 */
		public final static int TRANSACTIONCONSTRAINT = 100;

		/**
		 * The internal ID of the relvar
		 */
		public final static int TREEINDEXSPACE = 62;

		/**
		 * The internal ID for the relvar
		 */
		public final static int TRIGGEREDDATAACTION = 142;

		/**
		 * The internal ID for the relvar
		 */
		public final static int TUPLECONSTRAINT = 6;

		/**
		 * @deprecated
		 */
		public static final int TUPLECONSTRAINTATTRIBUTE = 82;

		/**
		 * The numerical ID of this relvar
		 */
		public static final int TUPLEINDEX = 90;

		/**
		 * The internal ID of the relvar
		 */
		public final static int JAVABACKEDTYPE = 64;

		/**
		 * The internal ID for the relvar
		 */
		public final static int TYPEPROPERTIES = 66;

		/**
		 * 
		 */
		public static final int UDTORDERINGOPERATOR = 138;

		/**
		 * 
		 */
		public static final int UDTPHYSICALPOSSREPCOMPONENT = 134;

		/**
		 * 
		 */
		public static final int UDTPOSSREP = 130;

		/**
		 * 
		 */
		public static final int UDTPOSSREPCOMPONENT = 132;

		/**
		 * 
		 */
		public static final int UDTPPCVALUESELECTOR = 140;

		/**
		 * Comment for <code>USER</code>
		 */
		public static final int USER = 114;

		/**
		 * The numeric ID of the relvar
		 */
		public static final int USERCERTIFICATE = 112;

		/**
		 * 
		 */
		public static final int USERDEFINEDTYPE = 128;

		/**
		 * Comment for <code>VIRTUALRELVAR</code>
		 */
		public static final int VIRTUALRELVAR = 38;

		/**
		 * The internal ID for this relvar
		 */
		public final static int VIRTUALRELVARREFERENCES = 122;

	}

	/**
	 * The STORAGESPACEIDS interface contains the values for the internal ID of all catalog storage spaces
	 * 
	 * @author Erwin
	 */
	public interface STORAGESPACEIDS {

		/**
		 * The internal ID for the ATTRIBUTE relvar
		 */
		public final static int ATTRIBUTE = 2;

		/**
		 * The internal ID for the locatorindex on the ATTRIBUTE relvar
		 */
		public final static int ATTRIBUTE_LOCATOR = 3;

		/**
		 * @deprecated - was a single hash on ATTRIBUTEVALUEDISTRIBUTION.{RELVARNAME ATTRIBUTENAME}, while the locator already has RELVARNAME (and ATTRIBUTENAME is unlikely to be a big extra discriminator for one relvar).
		 */
		public static final int ATTRIBUTEVALUEDISTRIBUTION = 56;

		/**
		 * @deprecated - moved into multihash STATISTICS_LOCATOR along with the RELVARCARDINALITY locator index.
		 */
		public static final int ATTRIBUTEVALUEDISTRIBUTION_LOCATOR = 57;

		/**
		 * The internal identification number used for the catalog dataspace
		 */
		public final static int CATALOGDATASPACE = 4;

		/**
		 * The storage space for indexes on CLIENTID and USERID
		 */
		public static final int CLIENT_LOCATOR = 117;

		/**
		 * 
		 */
		public static final int DATAACTION_LOCATOR = 145;

		/**
		 * @deprecated - was a single hash index storage space for DATASPACE.{FILENAME STORAGESPACEID} - the locator index on FILENAME should suffice
		 */
		public final static int DATASPACE = 12;

		/**
		 * The storage space for indexes on ERRORCODE
		 */
		public final static int ERRORCODE = 10;

		/**
		 * @deprecated - was a single hash index storage space for HASHINGINDEXSPACE.{FILENAME STORAGESPACEID} - the locator index on FILENAME should suffice
		 */
		public final static int HASHINGINDEXSPACE = 18;

		/**
		 * The Storage space for indexes on filename
		 */
		public final static int INDEX_FILENAME = 15;

		/**
		 * The Storage space for indexes on relvarname of the physical design relvars
		 */
		public final static int INDEX_LOCATOR = 21;

		/**
		 * The multihashing index space holding indexes on filename+storagespaceid (relvars INDEX & RECORDTYPE)
		 */
		public final static int INDEX_STORAGESPACE = 22;

		/**
		 * The Storage space for indexes on typename
		 */
		public final static int INDEX_TYPENAME = 65;

		/**
		 * @deprecated - was a single hash on INDEXCOMPONENT.{RELVARNAME INDEXNAME ORDINAL}, obviously used to enforce a key.  Given that the number of indexes per relvar and the number of components per index are likely to stay very small, having this index is overkill (the locator already has RELVARNAME)
		 */
		public static final int INDEXCOMPONENT = 74;

		/**
		 * @deprecated - was a single hash on INDEXID.{RELVARNAME INDEXNAME}.  The locator has RELVARNAME already, and the INDEXNAME is not an extra distinctor enough to warrant the index.  There are not likely to be hundreds of indexes on a single relvar.
		 */
		public static final int INDEXID = 76;

		/**
		 * @deprecated - was a single hash on INDEXID.{INDEXID}.  Moved into a multihash along with RELVARID.{RELVARID} and RECORDTYPEID.{RECORDTYPEID}
		 */
		public static final int INDEXID_ID = 78;

		/**
		 * @deprecated - was a single hash on KEY.{RELVARNAME KEYID}.  The locator already has RELVARNAME.
		 */
		public final static int KEY = 30;

		/**
		 * @deprecated - was a single hash on KEY.{RELVARNAME KEYID ATTRIBUTENAME}.  The locator already has RELVARNAME, and the number of keys per relvar, and number of attributes per key, are both very unlikely to run in the dozens.  So the locator index should suffice.
		 */
		public final static int KEYATTRIBUTE = 32;

		/**
		 * @deprecated - was a single hash index on MULTIHASHINGINDEXSPACE.{FILENAME STORAGESPACEID}.  The existing locator index on FILENAME should be sufficient.
		 */
		public static final int MULTIHASHINGINDEXSPACE = 80;

		/**
		 * @deprecated - was a single hash on NEWATTRIBUTEDEFAULTVALUE.{RELVARNAME ATTRIBUTENAME}.  The locator already has RELVARNAME.
		 */
		public final static int NEWATTRIBUTEDEFAULTVALUE = 48;

		/**
		 * @deprecated - was a single hash on RELVARNAME.  Moved into the MULTIHASH space for the RELVARNAME indexes on the physical design relvars.
		 */
		public final static int NEWATTRIBUTEDEFAULTVALUE_LOCATOR = 49;

		/**
		 * @deprecated - hash index on RECORDTYPE.{FILENAME STORAGESPACEID} is moved into multihash space 22 (together with INDEX.{FILENAME STORAGESPACEID})}
		 */
		public static final int RECORDTYPE_DATASPACE = 34;

		/**
		 * @deprecated - was a single hash on RECORDTYPE.{RELVARNAME INDEXNAME}.  The locator already has RELVARNAME.
		 */
		public final static int RECORDTYPE_LOCATORINDEXNAME = 36;

		/**
		 * @deprecated - was a single hash on RECORDTYPEID.{RECORDTYPEID}.  Moved into a multihash along with RELVARID.{RELVARID} and INDEXID.{INDEXID}.
		 */
		public static final int RECORDTYPEID_ID = 94;

		/**
		 * The storage space for holding indexes on {RELVARNAME} for the logical desing relvars.
		 */
		public final static int RELVAR_LOCATOR = 51;

		/**
		 * The storage space holding the tree index on RELVARATTRIBUTE.{ATTRIBUTENAME RELVARNAME}
		 */
		public final static int RELVARATTRIBUTE = 52;

		/**
		 * The storage space for RELVARNAME indexes for the statistics relvars
		 */
		public static final int STATISTICS_LOCATOR = 17;

		/**
		 * The internal ID of the relvar
		 */
		public final static int RELVARID = 54;

		/**
		 * @deprecated - was a single hash index on STORAGESPACE.{FILENAME STORAGESPACEID}
		 */
		public final static int STORAGESPACE = 58;

		/**
		 * @deprecated - TABLE_DEE and TABLE_DUM are now virtual relvars, defined by their appropriate relation value selector expression
		 */
		public static final int TABLE_DEE_LOCATOR = 73;

		/**
		 * @deprecated - TABLE_DEE and TABLE_DUM are now virtual relvars, defined by their appropriate relation value selector expression
		 */
		public static final int TABLE_DUM_LOCATOR = 71;

		/**
		 * @deprecated - was a single hash index on TREEINDEXSPACE.{FILENAME STORAGESPACEID}
		 */
		public final static int TREEINDEXSPACE = 62;

	}

	/**
	 * @author Erwin
	 * 
	 */
	public interface VERSION {

		/**
		 * 
		 */
		public static final short MAJORSPECIFICATIONVERSION = 1;

		/**
		 * 
		 */
		public static final short MINORSPECIFICATIONVERSION = 4;

	}

}
