/*
 * Created on 7-aug-2008
 */
package be.SIRAPRISE.client;

import java.util.LinkedHashSet;

/**
 * An InsertionOrderRelation is a relation that maintains its tuples in insertion order.
 * 
 * @author Erwin Smout
 */
public final class InsertionOrderRelation extends AbstractRelation {

	/**
	 * Creates the Relation object, declaring it to be of the given Heading type.
	 * 
	 * @param heading
	 *            The heading the tuples in this relation are expected to conform to.
	 */
	public InsertionOrderRelation (Heading heading) {
		super(heading, new LinkedHashSet<Tuple>());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.AbstractRelation#addOK(be.SIRAPRISE.client.Tuple)
	 */
	@Override
	public boolean addOK (Tuple tuple) {
		return true;
	}
}