/*
 * Created on 20-sep-2005
 */
package be.SIRAPRISE.client;

import java.util.logging.Logger;

import be.erwinsmout.MyProperties;

/**
 * The singleton class holding all the package's messages in a properties object
 * 
 * @author Erwin Smout
 */
class Messages extends MyProperties {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2125901607074421590L;

	/**
	 * The instance
	 */
	private static Messages instance = new Messages();

	/**
	 * Gets the instance of the class
	 * 
	 * @return the Messages instance
	 */
	private static Messages getInstance ( ) {
		return instance;
	}

	/**
	 * Obtains the message text corresponding to a given key
	 * 
	 * @param key
	 *            The key in the properties file
	 * @return The message text value associated with the key
	 */
	static String getString (String key) {
		String message = getInstance().getProperty(key);
		if (message == null) {
			if (key.equals("Messages.NotFound")) { //$NON-NLS-1$
				//				System.err.println("Problem with messages ..."); //$NON-NLS-1$
				Logger.getLogger(Messages.class.getName()).severe("Problem with messages ..."); //$NON-NLS-1$
				message = ""; //$NON-NLS-1$
			} else {
				message = getString("Messages.NotFound") + key; //$NON-NLS-1$
			}
		}
		return message;
	}

	/**
	 * Creates the messages instance. The message keys and text values are loaded.
	 */
	private Messages ( ) {

	}
}
