/*
 * Created on 13-mrt-2009
 */
package be.SIRAPRISE.client;

/**
 * The NAMES interface encloses interfaces that define the constant values for all sorts of names used in SIRA_PRISE
 * 
 * @author Erwin Smout
 */
public interface NAMES {

	/**
	 * The ALGORITHMNAMES interface defines the names of all system-defined algorithms used in SIRA_PRISE
	 * 
	 * @author Erwin
	 */
	public interface ALGORITHMNAMES {

		/**
		 * 
		 */
		public static final String MD5WITHRSA = "MD5WITHRSA"; //$NON-NLS-1$

	}

	/**
	 * The ATTRIBUTENAMES interface defines the names of all system-defined attributes used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface ATTRIBUTENAMES {

		/**
		 * 
		 */
		public static final String ALGORITHM = "ALGORITHM"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTENAME = "ATTRIBUTENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BASETYPE = "BASETYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BYPASSASSGCONSTRAINTS = "BYPASSASSGCONSTRAINTS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CARDINALITY = "CARDINALITY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CERTIFICATE = "CERTIFICATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CLIENTID = "CLIENTID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String COMPONENTNAME = "COMPONENTNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String COMPONENTTYPENAME = "COMPONENTTYPENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINTLABEL = "CONSTRAINTLABEL"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINTMESSAGETEXT = "CONSTRAINTMESSAGETEXT"; //$NON-NLS-1$

		/**
		 * @deprecated - replaced by USERID
		 */
		public static final String CONTEXTUSERID = "CONTEXTUSERID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CURRENTDATE = "CURRENTDATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATAACTIONNAME = "DATAACTIONNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ERRORCODE = "ERRORCODE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String EXTENTSCOUNT = "EXTENTSCOUNT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FILENAME = "FILENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FREQUENCY = "FREQUENCY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String GAPCOMPRESSIONTHRESHOLD = "GAPCOMPRESSIONTHRESHOLD"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXID = "INDEXID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXNAME = "INDEXNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INTERVALTYPENAME = "INTERVALTYPENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISDISTINCT = "ISDISTINCT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISORDERED = "ISORDERED"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISSCALAR = "ISSCALAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String LOGICALLENGTH = "LOGICALLENGTH"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MAXIMUMGAPS = "MAXIMUMGAPS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MAXIMUMSIZE = "MAXIMUMSIZE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MINIMUMSIZE = "MINIMUMSIZE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String OPERATIONTYPE = "OPERATIONTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ORDINAL = "ORDINAL"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String PAGECOUNT = "PAGECOUNT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String PAGESIZE = "PAGESIZE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String PHYSICALLENGTH = "PHYSICALLENGTH"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String POSSREPNAME = "POSSREPNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPEID = "RECORDTYPEID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPENAME = "RECORDTYPENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String REFERENCEDRELVARNAME = "REFERENCEDRELVARNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARID = "RELVARID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARNAME = "RELVARNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARPREDICATE = "RELVARPREDICATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SP_EXPRESSION = "SP_EXPRESSION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String STDDEV = "STDDEV"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String STORAGESPACEID = "STORAGESPACEID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TARGETRELVARNAME = "TARGETRELVARNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TRIGGEREDOPERATIONTYPE = "TRIGGEREDOPERATIONTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TRUSTAUTHENTICATION = "TRUSTAUTHENTICATION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TYPENAME = "TYPENAME"; //$NON-NLS-1$

		/**
		 * @deprecated - current transaction context and transaction constraints are to be replaced by assignment constraints
		 */
		public static final String UPDATEDRELVARNAME = "UPDATEDRELVARNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String USERID = "USERID"; //$NON-NLS-1$

		/**
		 * @deprecated - replaced by SP_EXPRESSION
		 */
		public static final String VALUE = "VALUE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VALUECOUNT = "VALUECOUNT"; //$NON-NLS-1$

	}

	/**
	 * The CLIENTANDUSERNAMES interface defines the names of all system-defined clients and users used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface CLIENTANDUSERNAMES {

		/**
		 * 
		 */
		public static final String REGISTERX509CERTIFICATE = "REGISTERX509CERTIFICATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SERVERENGINE = "SERVERENGINE"; //$NON-NLS-1$

	}

	/**
	 * The COMMANDNAMES interface defines the names of all system-defined commands used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface COMMANDNAMES {

		/**
		 * 
		 */
		public static final String ADD = "ADD"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ASSERT = "ASSERT"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String CACHE = "CACHE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CMD = "CMD"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String COMMIT = "COMMIT"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String COMPILE = "COMPILE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CREATE = "CREATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DELETE = "DELETE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INQUIRE = "INQUIRE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INSERT = "INSERT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MODIFY = "MODIFY"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String PREPARE = "PREPARE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String REMOVE = "REMOVE"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String ROLLBACK = "ROLLBACK"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UNASSERT = "UNASSERT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UPDATE = "UPDATE"; //$NON-NLS-1$

	}

	/**
	 * The FILENAMES interface defines the names of all system-defined files used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface FILENAMES {

		/**
		 * 
		 */
		public static final String DATABASECATALOG_SPDB = "DATABASECATALOG.SPDB"; //$NON-NLS-1$

	}

	/**
	 * The INDEXNAMES interface defines the names of all system-defined indexes that are not the locator index of a system-defined relvar
	 * 
	 * @author Erwin Smout
	 */
	public interface INDEXNAMES {

		/**
		 * 
		 */
		public static final String ASSIGNMENTCONSTRAINTCHECK_ERRORCODE = "ASSIGNMENTCONSTRAINTCHECK_ERRORCODE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTE = "ATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTE_TYPE = "ATTRIBUTE_TYPE"; //$NON-NLS-1$

		/**
		 * @deprecated - was a single hash on ATTRIBUTEVALUEDISTRIBUTION.{RELVARNAME ATTRIBUTENAME}, while the locator already has RELVARNAME (and ATTRIBUTENAME is unlikely to be a big extra discriminator for one relvar).
		 */
		public static final String ATTRIBUTEVALUEDISTRIBUTION_ID = "ATTRVALDISTR_ID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINEDTYPE_BASETYPE = "CONSTRAINEDTYPE_BASETYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINTINVRELVAR_RELVAR = "CONSTRAINTINVRELVAR_RELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATAACTION_REFERENCEDRELVAR = "DATAACTION_REFERENCEDRELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATAACTIONNAME = "DATAACTIONNAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATABASECONSTRAINTCHECK_ERRORCODE = "DATABASECONSTRAINTCHECK_ERRORCODE"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String DATASPACE_ID = "DATASPACE_ID"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String HASHINGINDEXSPACE_ID = "HASHINGINDEXSPACE_ID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEX_STORAGESPACE = "INDEX_STORAGESPACE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXID_ID = "INDEXID_ID"; //$NON-NLS-1$

		/**
		 * @deprecated - was a single hash on INDEXID.{RELVARNAME INDEXNAME}. The locator has RELVARNAME already, and the INDEXNAME is not an extra distinctor enough to warrant the index. There are not likely to be hundreds of indexes on a single relvar.
		 */
		public static final String INDEXID_NAMES = "INDEXID_NAMES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INTERVALTYPE_NAME = "INTERVALTYPE_NAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String KEY_ERRORCODE = "KEY_ERRORCODE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String KEYATTRIBUTE_ERRORCODE = "KEYATTRIBUTE_ERR"; //$NON-NLS-1$

		/**
		 * @deprecated - was an index on {FILENAME STORAGESPACEID} where the locator already had FILENAME
		 */
		public static final String MULTIHASHINGINDEXSPACE_ID = "MULTIHASHINGINDEXSPACE_ID"; //$NON-NLS-1$

		/**
		 * @deprecated - was a single hash on NEWATTRIBUTEDEFAULTVALUE.{RELVARNAME ATTRIBUTENAME}. The locator already has RELVARNAME.
		 */
		public static final String NEWATTRIBUTEDEFAULTVALUE = "NEWATTRIBUTEDFTVALUE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPE_DATASPACE = "RECORDTYPE_DATASPACE"; //$NON-NLS-1$

		/**
		 * @deprecated - was a single hash on RECORDTYPE.{RELVARNAME INDEXNAME}. The locator already has RELVARNAME.
		 */
		public static final String RECORDTYPE_LOCATORINDEX = "RECORDTYPE_LOCATORINDEX"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPEID_ID = "RECORDTYPEID_ID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARATTRIBUTE_ATTRIBUTE = "RELVARATTRIBUTE_ATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARID_ID = "RELVARID_ID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARREFERENCES_BASE = "RELVARREFERENCES_BASE"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String STORAGESPACE_ID = "STORAGESPACE_ID"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String TREEINDEXSPACE_ID = "TREEINDEXSPACE_ID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TRIGGEREDDATAACTION_TARGETRELVAR = "TRIGGEREDDATAACTION_TARGETRELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TUPLECONSTRAINT_ERRORCODE = "TUPLECONSTRAINT_ERRORCODE"; //$NON-NLS-1$

	}

	/**
	 * The OPERATORNAMES interface defines the names of all system-defined relational operators used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface OPERATORNAMES {

		/**
		 * 
		 */
		public static final String AGGREGATE = "AGGREGATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DELETES = "DELETES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DELETESBAC = "DELETESBAC"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DELETESSAC = "DELETESSAC"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DIVIDEBYPER = "DIVIDEBYPER"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String EXTEND = "EXTEND"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String GROUP = "GROUP"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INSERTS = "INSERTS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INSERTSBAC = "INSERTSBAC"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INSERTSSAC = "INSERTSSAC"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INTERSECT = "INTERSECT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String JOIN = "JOIN"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String LEFTJOIN = "LEFTJOIN"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MINUS = "MINUS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String PROJECT = "PROJECT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RENAME = "RENAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RESTRICT = "RESTRICT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SEMIJOIN = "SEMIJOIN"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SEMIMINUS = "SEMIMINUS"; //$NON-NLS-1$

		/**
		 * 
		 */
		//		public static final String SPECIALINTERNAL1 = "SPECIALINTERNAL1"; //$NON-NLS-1$

		/**
		 * 
		 */
		//		public static final String SPECIALINTERNAL2 = "SPECIALINTERNAL2"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SUMMARIZEBY = "SUMMARIZEBY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TCLOSE = "TCLOSE"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String TRANSACTION = "TRANSACTION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TRANSFORM = "TRANSFORM"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UNGROUP = "UNGROUP"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UNION = "UNION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String XMINUS = "XMINUS"; //$NON-NLS-1$

	}

	/**
	 * The POSSREPCOMPONENTNAMES interface defines the names of all comonents of possreps of system-defined types used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface POSSREPCOMPONENTNAMES {

		/**
		 * 
		 */
		public static final String BEGIN = "BEGIN"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BODY = "BODY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String COUNT = "COUNT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DAY = "DAY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DEGREES = "DEGREES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String END = "END"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FROM = "FROM"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HEADING = "HEADING"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HEX = "HEX"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HOURS = "HOURS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISO = "ISO"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISOWITHNANOSECONDS = "ISOWITHNANOSECONDS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MINUTES = "MINUTES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MONTH = "MONTH"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String NANOSECONDS = "NANOSECONDS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RADIANS = "RADIANS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SECONDS = "SECONDS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String STRING = "STRING"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TO = "TO"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UNICODE = "UNICODE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VALUE = "VALUE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String YEAR = "YEAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String YN = "YN"; //$NON-NLS-1$

	}

	/**
	 * The POSSREPNAMES interface defines the names of all possreps of system-defined types used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface POSSREPNAMES {

		/**
		 * 
		 */
		public static final String ANGLE = "ANGLE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String AVERAGE = "AVERAGE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BITS = "BITS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CHAR = "CHAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DECIMAL = "DECIMAL"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DMY = "DMY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FILENAME = ATTRIBUTENAMES.FILENAME;

		/**
		 * 
		 */
		public static final String FLOAT = "FLOAT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FROMTO = "FROMTO"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HEX = "HEX"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HMS = "HMS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INT = "INT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISO = "ISO"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ISOWITHNANOSECONDS = "ISOWITHNANOSECONDS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String LONG = "LONG"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String NAME = "NAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RADIANS = "RADIANS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELATION = "RELATION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TUPLE = "TUPLE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UNICODE = "UNICODE"; //$NON-NLS-1$

	}

	/**
	 * The RELVARNAMES interface defines the names of all system-defined relvars used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	interface RELVARNAMES {

		/**
		 * 
		 */
		public static final String ASSIGNMENTCONSTRAINT = "ASSIGNMENTCONSTRAINT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ASSIGNMENTCONSTRAINTCHECK = "ASSIGNMENTCONSTRAINTCHECK"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTE = "ATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTELOGICALLENGTH = "ATTRIBUTELOGICALLENGTH"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTEPHYSICALLENGTH = "ATTRIBUTEPHYSICALLENGTH"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String ATTRIBUTEVALUEDISTRIBUTION = "ATTRIBUTEVALUEDISTRIBUTION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CLIENT = "CLIENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CLIENTCERTIFICATE = "CLIENTCERTIFICATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINEDTYPE = "CONSTRAINEDTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINTINVOLVESRELVAR = "CONSTRAINTINVOLVESRELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CONSTRAINTMESSAGETEXT = "CONSTRAINTMESSAGETEXT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CURRENTCONTEXT = "CURRENTCONTEXT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CURRENTDATE = "CURRENTDATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CURRENTUPDATE = "CURRENTUPDATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CURRENTUSER = "CURRENTUSER"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATAACTIONREFERENCES = "DATAACTIONREFERENCES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATABASECONSTRAINT = "DATABASECONSTRAINT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATABASECONSTRAINTCHECK = "DATABASECONSTRAINTCHECK"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATASPACE = "DATASPACE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DBMSFILE = "DBMSFILE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String HASHINGINDEXSPACE = "HASHINGINDEXSPACE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEX = "INDEX"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXATTRIBUTE = "INDEXATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXCOMPONENT = "INDEXCOMPONENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INDEXID = "INDEXID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INTERVALTYPE = "INTERVALTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String JAVABACKEDTYPE = "JAVABACKEDTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String KEY = "KEY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String KEYATTRIBUTE = "KEYATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String MULTIHASHINGINDEXSPACE = "MULTIHASHINGINDEXSPACE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String NEWATTRIBUTEDEFAULTVALUE = "NEWATTRIBUTEDEFAULTVALUE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String POSSREP = "POSSREP"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String POSSREPCOMPONENT = "POSSREPCOMPONENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDATTRIBUTE = "RECORDATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPE = "RECORDTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RECORDTYPEID = "RECORDTYPEID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVAR = "RELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARATTRIBUTE = "RELVARATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARCARDINALITY = "RELVARCARDINALITY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARCLUSTER = "RELVARCLUSTER"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELVARID = "RELVARID"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String STORAGESPACE = "STORAGESPACE"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String STORAGESPACEEXTENTS = "STORAGESPACEEXTENTS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDCLIENT = "SYSTEMDEFINEDCLIENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDCONSTRAINT = "SYSTEMDEFINEDCONSTRAINT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDDBMSFILE = "SYSTEMDEFINEDDBMSFILE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDRELVAR = "SYSTEMDEFINEDRELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDTYPE = "SYSTEMDEFINEDTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String SYSTEMDEFINEDUSER = "SYSTEMDEFINEDUSER"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TABLE_DEE = "TABLE_DEE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TABLE_DUM = "TABLE_DUM"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String TRANSACTIONCONSTRAINT = "TRANSACTIONCONSTRAINT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TREEINDEXSPACE = "TREEINDEXSPACE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TRIGGEREDDATAACTION = "TRIGGEREDDATAACTION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TUPLECONSTRAINT = "TUPLECONSTRAINT"; //$NON-NLS-1$

		/**
		 * @deprecated
		 */
		public static final String TUPLECONSTRAINTATTRIBUTE = "TUPLECONSTRAINTATTRIBUTE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TUPLEINDEX = "TUPLEINDEX"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TYPEDIRECTLYREFERENCEDBY = "TYPEDIRECTLYREFERENCEDBY"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TYPEPROPERTIES = "TYPEPROPERTIES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UDTORDERINGOPERATOR = "UDTORDERINGOPERATOR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UDTPHYSICALPOSSREPCOMPONENT = "UDTPHYSICALPOSSREPCOMPONENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UDTPOSSREP = "UDTPOSSREP"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UDTPOSSREPCOMPONENT = "UDTPOSSREPCOMPONENT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String UDTPPCVALUESELECTOR = "UDTPPCVALUESELECTOR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String USER = "USER"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String USERCERTIFICATE = "USERCERTIFICATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String USERDEFINEDTYPE = "USERDEFINEDTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VIRTUALRELVAR = "VIRTUALRELVAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VIRTUALRELVARDEPENDSONTYPE = "VIRTUALRELVARDEPENDSONTYPE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VIRTUALRELVARREFERENCES = "VIRTUALRELVARREFERENCES"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String VIRTUALRELVARDEPENDENCYGRAPH = "VIRTUALRELVARDEPENDENCYGRAPH"; //$NON-NLS-1$

	}

	/**
	 * The TYPENAMES interface defines the names of all system-defined types used in SIRA_PRISE
	 * 
	 * @author Erwin Smout
	 */
	public interface TYPENAMES {

		/**
		 * 
		 */
		public static final String ANGLE = "ANGLE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String AVERAGE = "AVERAGE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BITS = "BITS"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String BOOLEAN = "BOOLEAN"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String CHAR = "CHAR"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DATE = "DATE"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String DECIMAL = "DECIMAL"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String FILENAME = ATTRIBUTENAMES.FILENAME;

		/**
		 * 
		 */
		public static final String FLOAT = "FLOAT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String INT = "INT"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String LONG = "LONG"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String NAME = "NAME"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String RELATION = "RELATION"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String STRING = "STRING"; //$NON-NLS-1$

		/**
		 * 
		 */
		public static final String TIMEOFDAY = "TIMEOFDAY"; //$NON-NLS-1$

		/**
		 * The TUPLE type is still experimental. Its use as such is strongly discouraged.
		 */
		public static final String TUPLE = "TUPLE"; //$NON-NLS-1$

	}

	/**
	 * 
	 */
	public static final String DEFAULTKEYSTORETYPE = "JKS"; //$NON-NLS-1$

	/**
	 * 
	 */
	public static final String INTERNALPARAMETERSPREFIX = "__C"; //$NON-NLS-1$
}