/*
 * Created on 13-okt-2008
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * A NonScalarTypeDeclaration is a TypeDeclaration that accompanies the name of an attribute in a Heading if that attribute is relation-typed or tuple-typed.
 * 
 * @author Erwin Smout
 */
public class NonScalarTypeDeclaration implements TypeDeclaration {

	/**
	 * The heading
	 */
	private Heading heading;

	/**
	 * Creates the typedeclaration
	 * 
	 * @param heading
	 *            The heading
	 */
	NonScalarTypeDeclaration (Heading heading) {
		this.heading = heading;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeDeclaration#getHeading()
	 */
	public Heading getHeading ( ) {
		return heading;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeDeclaration#getTypeName()
	 */
	public String getTypeName ( ) {
		return TYPENAMES.RELATION;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeDeclaration#isScalar()
	 */
	public boolean isScalar ( ) {
		return false;
	}
}