/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.IOException;
import java.util.Set;
import be.SIRAPRISE.messages.EndConnectionMessageType;
import be.SIRAPRISE.messages.ServerMessageTypes;
import be.erwinsmout.NotFoundException;

/**
 * A OneShotDBConnection has all the semantics of a DBConnection. The close() method actually closes the connection, such that the connection cannot be recycled for reuse in the context of a connection pool.
 * 
 * @author Erwin
 */
public final class OneShotDBConnection extends DBConnection {

	/**
	 * Creates a connection to the server on the specified host and port with the given autoCommit setting, and opens it for communication.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param encryptionAlgorithmNames
	 *            A specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port with the given autoCommit setting, and opens it for communication.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param privateKeyProvider
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, Signer privateKeyProvider) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, privateKeyProvider);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, requestConnectionIdleTime, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param signatureAlgorithmNames
	 *            a specified set of usable signature algorithm names
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, Set<String> signatureAlgorithmNames, String clientID, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, signatureAlgorithmNames, clientID, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port with the given autoCommit setting, and opens it for communication.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param encryptionAlgorithmNames
	 *            A specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port with the given autoCommit setting, and opens it for communication.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, boolean initialAutoCommitForTransactions, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, initialAutoCommitForTransactions, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param initialAutoCommitForTransactions
	 *            true if the transactions created on this connection should have their autocommit set to true
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, boolean initialAutoCommitForTransactions, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, initialAutoCommitForTransactions, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param requestConnectionIdleTime
	 *            The requested time in milliseconds that the connection is allowed to stay idle
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, requestConnectionIdleTime, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param encryptionAlgorithmNames
	 *            a specified set of usable encryption protocol names
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, encryptionAlgorithmNames, signer);
	}

	/**
	 * Creates a connection to the server on the specified host and port, and opens it for communication. AutoCommit will be OFF. The requested connection idle time is the default time configured in the client properties.
	 * 
	 * @param host
	 *            The identification of the host. It may either be its DNS name or its IP address in dotted decimal.
	 * @param port
	 *            The port to which to connect.
	 * @param clientID
	 *            The ID identifying the client of this connection to sira_prise
	 * @param signer
	 *            The Signer object that will be called upon to compute the needed signature
	 * @throws IOException
	 *             if an I/O error occurs when creating the TCP socket.
	 * @throws CommunicationProtocolException
	 *             If an unexpected message was received during the handshake
	 * @throws DBException
	 *             If an error was detected on the server during the handshake
	 */
	public OneShotDBConnection (String host, int port, String clientID, Signer signer) throws IOException, CommunicationProtocolException, DBException {
		super(host, port, clientID, signer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.DBConnection#close()
	 */
	@Override
	public void close ( ) {
		if (isOpen()) {
			try {
				endAnyTransaction();
				((EndConnectionMessageType) ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(EndConnectionMessageType.MESSAGETYPEID, getSpecificationVersionForServer())).message().sendMessage(getSocketOutputStream(), getSigningProtocol(), getSigner(), getCryptoProtocol());
			} catch (IOException e) {

			} catch (CommunicationProtocolException e) {

			} catch (NotFoundException e) {

			} finally {
				closeSockets();
			}
		}
	}

}
