/*
 * Created on 7-aug-2008
 */
package be.SIRAPRISE.client;

import java.util.TreeSet;

/**
 * An OrderedRelation is a relation that maintains its tuples in the order determined by the given comparator
 * 
 * @author Erwin Smout
 */
public final class OrderedRelation extends AbstractRelation {

	/**
	 * @param tupleOrderer
	 * @param heading
	 */
	public OrderedRelation (TupleOrderer tupleOrderer, Heading heading) {
		super(heading, new TreeSet<Tuple>(tupleOrderer));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.AbstractRelation#addOK(be.SIRAPRISE.client.Tuple)
	 */
	@Override
	public boolean addOK (Tuple tuple) {
		return true;
	}
}