/*
 * Created on 13-okt-2008
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * A ScalarTypeDeclaration is the type declaration for attributes in a heading if that attribute is not relation- or tuple-typed. A ScalarTypeDeclaration requires only the name of the concerned scalar type.
 * 
 * @author Erwin Smout
 */
final class ScalarTypeDeclaration implements TypeDeclaration {

	/**
	 * The type name
	 */
	private String typeName;

	/**
	 * Creates the typedeclaration-by-name
	 * 
	 * @param typeName
	 *            The type name
	 */
	ScalarTypeDeclaration (String typeName) {
		if (typeName.equalsIgnoreCase(TYPENAMES.RELATION) || typeName.equalsIgnoreCase(TYPENAMES.TUPLE)) {
			throw new IllegalArgumentException(typeName);
		}
		this.typeName = typeName;
	}

	/**
	 * Gets The type name
	 * 
	 * @return Returns The type name
	 */
	public final String getTypeName ( ) {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeDeclaration#isScalar()
	 */
	public boolean isScalar ( ) {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeDeclaration#getHeading()
	 */
	public Heading getHeading ( ) throws TypeIsScalarException {
		throw new TypeIsScalarException();
	}
}
