/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * A ServerAddCommand consists of two portions :
 * <ul>
 * <li>The target relvar name</li>
 * <li>The relational expression defining which tuples in the target relvar will be added</li>
 * </ul>

 * @author Erwin
 * 
 */
public final class ServerAddCommand extends ServerBasicAssignmentCommand {

	/**
	 * Creates the ServerAddCommand
	 * 
	 * @param targetRelvarName
	 *            The target relvar Name
	 * @param insert
	 *            The textual representation of the RA formula defining the relation to be inserted into the target
	 */
	public ServerAddCommand (String targetRelvarName, String insert) {
		super(targetRelvarName, insert);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandParametersText()
	 */
	@Override
	public String getCommandParametersText ( ) {
		return getTargetRelvarName() + ',' + getRelationExpressionText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandText()
	 */
	public String getFullCommandText ( ) {
		return COMMANDNAMES.ADD + ' ' + getCommandParametersText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecAssignmentCommand#writeToStream(java.io.DataOutputStream)
	 */
	@Override
	public void writeAssignmentTypeSpecificToStream (DataOutputStream outputStream) throws IOException {
		outputStream.writeByte(DmlAddCommand.ASSIGNMENTTYPE);
		MyDataOutputStream.writeSmallUTF(getTargetRelvarName(), outputStream);
		MyDataOutputStream.writeBigUTF(getRelationExpressionText(), outputStream);
	}
}
