/**
 * 
 */
package be.SIRAPRISE.client;

/**
 * A ServerBasicAssignmentCommand is a server update command that constitutes a single basic operation type on a single relvar target. UPDATE is the equivalent of a combined DELETE/INSERT, hence it does not constitute a 'basic' assignment command.
 * 
 * @author Erwin
 */
public abstract class ServerBasicAssignmentCommand extends ServerSingleAssignmentCommand {

	/**
	 * The expression text defining the relation that will be used in the command's operation type against the target relvar
	 */
	private String relationExpressionText;

	/**
	 * Creates the ServerBasicAssignmentCommand
	 * 
	 * @param targetRelvarName
	 *            The name of the relvar targeted by this individual update command
	 * @param relationExpressionText
	 *            The expression text defining the relation that will be used in the command's operation type against the target relvar
	 */
	ServerBasicAssignmentCommand (String targetRelvarName, String relationExpressionText) {
		super(targetRelvarName);
		this.relationExpressionText = relationExpressionText;
	}

	/**
	 * Gets The expression text defining the relation that will be used in the command's operation type against the target relvar
	 * 
	 * @return The expression text defining the relation that will be used in the command's operation type against the target relvar
	 */
	public final String getRelationExpressionText ( ) {
		return relationExpressionText;
	}

}
