/**
 * 
 */
package be.SIRAPRISE.client;

import java.util.LinkedList;
import java.util.List;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.messages.ExecuteQueryMessageType;

/**
 * A NonAssignmentCommand is a command that will not assign a new value to the database, such as INQUIRE. A subclass exists for each particular type.
 * 
 * @author Erwin
 */
public final class ServerInquireCommand extends ServerNonAssignmentCommand {

	/**
	 * The target relvar Name
	 */
	private String expressionText;

	/**
	 * The ordering spec for the inquire command.
	 */
	private List<String> orderByAttributeNames;

	/**
	 * Creates the ServerInquireCommand, setting the expression to be inquired, with no requested ordering
	 * 
	 * @param expressionText
	 *            The target relvar Name
	 */
	ServerInquireCommand (String expressionText) {
		this(expressionText, new LinkedList<String>());
	}

	/**
	 * Creates the ServerInquireCommand, setting the expression to be inquired, plus the given requested ordering
	 * 
	 * @param expressionText
	 *            The target relvar Name
	 * @param orderByAttributeNames
	 *            The ordering spec for the inquire command.
	 */
	ServerInquireCommand (String expressionText, LinkedList<String> orderByAttributeNames) {
		this.expressionText = expressionText;
		this.orderByAttributeNames = orderByAttributeNames;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCorrespondingMessagetypeid()
	 */
	@Override
	final int getCorrespondingMessagetypeid ( ) {
		return ExecuteQueryMessageType.MESSAGETYPEID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandParametersText()
	 */
	@Override
	public String getCommandParametersText ( ) {
		return expressionText;
	}

	/**
	 * Gets The target relvar Name
	 * 
	 * @return The target relvar Name
	 */
	public final String getExpressionText ( ) {
		return expressionText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandText()
	 */
	public String getFullCommandText ( ) {
		return COMMANDNAMES.INQUIRE + ' ' + expressionText;
	}

	/**
	 * Gets The ordering spec for the inquire command.
	 * 
	 * @return The ordering spec for the inquire command.
	 */
	public List<String> getOrderByAttributeNames ( ) {
		return orderByAttributeNames;
	}
}
