/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;

/**
 * A ServerMultipleAssignmentCommand is a command that consists of >1 IndividualAssignmentCommands.
 * 
 * @author Erwin
 */
public final class ServerMultipleAssignmentCommand extends ServerAssignmentCommand {

	/**
	 * The individual assignments that make up the multiple assignment
	 */
	private ServerSingleAssignmentCommand[] individualAssignmentCommands;

	/**
	 * Creates the ServerMultipleAssignmentCommand. If an individual assignment in the given array is itself a multiple assignment, then that "individual multiple" assignment is unwrapped, so that the constituent assignment of the Multiple Assignment created, will all be SingleAssignmentCommands.
	 * 
	 * @param individualAssignments
	 *            The individual assignments that make up the multiple assignment. If an individual assignment is itself a Multiple Assignment MA, the individual assignments that constitute it will take the place of MA in the Ma object being constructed.
	 */
	public ServerMultipleAssignmentCommand (ServerAssignmentCommand[] individualAssignments) {
		LinkedList<ServerSingleAssignmentCommand> individualAssignmentsList = new LinkedList<ServerSingleAssignmentCommand>();

		for (ServerAssignmentCommand individualAssignment : individualAssignments) {
			if (individualAssignment instanceof ServerSingleAssignmentCommand) {
				individualAssignmentsList.addLast((ServerSingleAssignmentCommand) individualAssignment);
			} else {
				for (ServerSingleAssignmentCommand serverSingleAssignmentCommand : ((ServerMultipleAssignmentCommand) individualAssignment).getIndividualAssignmentCommands()) {
					individualAssignmentsList.addLast(serverSingleAssignmentCommand);
				}
			}
		}

		this.individualAssignmentCommands = individualAssignmentsList.toArray(new ServerSingleAssignmentCommand[] {});
	}

	/**
	 * Creates the ServerMultipleAssignmentCommand
	 * 
	 * @param individualAssignmentCommands
	 *            The individual assignments that make up the multiple assignment
	 */
	public ServerMultipleAssignmentCommand (ServerSingleAssignmentCommand[] individualAssignmentCommands) {
		this.individualAssignmentCommands = individualAssignmentCommands;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandParametersText()
	 */
	@Override
	public String getCommandParametersText ( ) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandText()
	 */
	@Override
	public String getFullCommandText ( ) {
		StringBuilder w = new StringBuilder(128 * individualAssignmentCommands.length);
		for (ServerSingleAssignmentCommand individualAssignmentCommand : individualAssignmentCommands) {
			w.append(COMMANDNAMES.CMD).append('(').append(individualAssignmentCommand.getFullCommandText()).append(')');
		}
		return w.toString();
	}

	/**
	 * Gets The individual assignments that make up the multiple assignment
	 * 
	 * @return The individual assignments that make up the multiple assignment
	 */
	public final ServerSingleAssignmentCommand[] getIndividualAssignmentCommands ( ) {
		return individualAssignmentCommands;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#writeToStream(java.io.DataOutputStream)
	 */
	@Override
	public final void writeToStream (DataOutputStream outputStream) throws IOException {
		int count = individualAssignmentCommands.length;
		outputStream.writeInt(count);
		int i = 0;
		while (i < count) {
			individualAssignmentCommands[i++].writeAssignmentTypeSpecificToStream(outputStream);
		}
	}
}
