/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.DataOutputStream;
import java.io.IOException;

/**
 * An AssignmentCommand is a command that will assign a new value to the database, such as ADD,ASSERT,UPDATE. A subclass exists for each particular type.
 * 
 * @author Erwin
 */
public abstract class ServerSingleAssignmentCommand extends ServerAssignmentCommand {

	/**
	 * The target relvar Name
	 */
	private String targetRelvarName;

	/**
	 * Creates the ServerSingleAssignmentCommand
	 * 
	 * @param targetRelvarName
	 *            The target relvar Name of this 'individual' assignment
	 */
	ServerSingleAssignmentCommand (String targetRelvarName) {
		this.targetRelvarName = targetRelvarName;
	}

	/**
	 * @param outputStream
	 * @throws IOException
	 */
	abstract void writeAssignmentTypeSpecificToStream (DataOutputStream outputStream) throws IOException;

	/**
	 * Gets The target relvar Name of this 'individual' assignment
	 * 
	 * @return The target relvar Name of this 'individual' assignment
	 */
	public final String getTargetRelvarName ( ) {
		return targetRelvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#writeToStream(java.io.DataOutputStream)
	 */
	@Override
	public final void writeToStream (DataOutputStream outputStream) throws IOException {
		outputStream.writeInt(1);
		writeAssignmentTypeSpecificToStream(outputStream);
	}

}
