/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * A ServerDeleteCommand consists of two portions :
 * <ul>
 * <li>The target relvar name</li>
 * <li>The relational expression defining which tuples in the target relvar will be removed-if-present from the current value of the relvar.</li>
 * </ul>
 * @author Erwin
 * 
 */
public final class ServerUnassertCommand extends ServerBasicAssignmentCommand {

	/**
	 * Creates the ServerUnassertCommand
	 * 
	 * @param targetRelvarName
	 *            The target relvar Name
	 * @param delete
	 *            The textual representation of the RA formula defining the relation to be deleted from the target
	 */
	public ServerUnassertCommand (String targetRelvarName, String delete) {
		super(targetRelvarName, delete);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandParametersText()
	 */
	@Override
	public String getCommandParametersText ( ) {
		return getTargetRelvarName() + ',' + getRelationExpressionText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandText()
	 */
	public String getFullCommandText ( ) {
		return COMMANDNAMES.UNASSERT + ' ' + getCommandParametersText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecAssignmentCommand#writeToStream(java.io.DataOutputStream)
	 */
	@Override
	public void writeAssignmentTypeSpecificToStream (DataOutputStream outputStream) throws IOException {
		outputStream.writeByte(DmlUnassertCommand.ASSIGNMENTTYPE);
		MyDataOutputStream.writeSmallUTF(getTargetRelvarName(), outputStream);
		MyDataOutputStream.writeBigUTF(getRelationExpressionText(), outputStream);
	}

}
