/**
 * 
 */
package be.SIRAPRISE.client;

import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.NAMES.COMMANDNAMES;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * A ServerUpdateCommand consists of three portions :
 * <ul>
 * <li>The target relvar name</li>
 * <li>The relational expression defining which tuples in the target relvar will be affected (=deleted) by the update</li>
 * <li>The specification of the changes that have to be applied to all affected tuples, i.e. the specification of how to compute, for each affected tuple, what the replacing tuple will be.</li>
 * </ul>
 * 
 * @author Erwin
 */
public final class ServerUpdateCommand extends ServerSingleAssignmentCommand {

	/**
	 * The textual representation of the RA formula defining how to compute the replacing tuples
	 */
	private String changes;

	/**
	 * The textual representation of the RA formula defining the relation to be deleted from the target
	 */
	private String deleteRelationExpressionText;

	/**
	 * Creates the ExecUpdateCommand
	 * 
	 * @param targetRelvarName
	 *            The target relvar Name
	 * @param deleteRelationExpressionText
	 *            The textual representation of the RA formula defining the relation to be deleted from the target
	 * @param changes
	 *            The textual representation of the RA formula defining how to compute the replacing tuples. May not be enclosed in '(' and ')'.
	 */
	public ServerUpdateCommand (String targetRelvarName, String deleteRelationExpressionText, String changes) {
		super(targetRelvarName);
		this.deleteRelationExpressionText = deleteRelationExpressionText;
		this.changes = changes;
	}

	/**
	 * Gets The textual representation of the RA formula defining how to compute the replacing tuples. Is not be enclosed in '(' and ')'.
	 * 
	 * @return The textual representation of the RA formula defining how to compute the replacing tuples. Is not be enclosed in '(' and ')'.
	 */
	public final String getChanges ( ) {
		return changes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandParametersText()
	 */
	@Override
	public String getCommandParametersText ( ) {
		return getTargetRelvarName() + ',' + deleteRelationExpressionText + ',' + '(' + changes + ')';
	}

	/**
	 * Gets The textual representation of the RA formula defining the relation to be deleted from the target
	 * 
	 * @return The textual representation of the RA formula defining the relation to be deleted from the target
	 */
	public final String getDeleteRelationExpressionText ( ) {
		return deleteRelationExpressionText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.ServerCommand#getCommandText()
	 */
	public String getFullCommandText ( ) {
		return COMMANDNAMES.UPDATE + ' ' + getCommandParametersText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.messages.ExecAssignmentCommand#writeToStream(java.io.DataOutputStream)
	 */
	@Override
	public void writeAssignmentTypeSpecificToStream (DataOutputStream outputStream) throws IOException {
		outputStream.writeByte(DmlUpdateCommand.ASSIGNMENTTYPE);
		MyDataOutputStream.writeSmallUTF(getTargetRelvarName(), outputStream);
		MyDataOutputStream.writeBigUTF(deleteRelationExpressionText, outputStream);
		MyDataOutputStream.writeBigUTF(changes, outputStream);
	}

}
