/*
 * Created on 4-aug-2008
 */
package be.SIRAPRISE.client;

import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;

import be.erwinsmout.NotFoundException;

/**
 * Signers are used by clients in two circumstances :
 * <ul>
 * <li>The client needs to establish a connection to a server and wants to authenticate itself</li>
 * <li>The client needs to start a transaction for a non-anonymous user and wants/needs to authenticate the user identity by computing a signature</li>
 * </ul>
 * 
 * @author Erwin Smout
 */
public interface Signer {

	/**
	 * Computes the signature for the given byte string and the given Signature. Normally, this involves three method invocations on the given Signature object :
	 * <ul>
	 * <li>initSign() the Signature with a PrivateKey object which is to be obtained from private resources</li>
	 * <li>update() the Signature with the given byte string</li>
	 * <li>sign() to compute the signature bytes</li>
	 * </ul>
	 * 
	 * @param signature
	 *            The Signature object to be used for computing the signature.
	 * @param signMessage
	 *            The message to be signed.
	 * @return the computed signature
	 * @throws InvalidKeyException
	 *             If the private key found for signing with this Signature, turns out to be invalid
	 * @throws SignatureException
	 *             If any problem occurred during computation of the signature
	 * @throws NotFoundException
	 *             If no private key could be found for signing with this Signature
	 */
	byte[] sign (Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException;

}