/**
 * 
 */
package be.SIRAPRISE.client;

/**
 * @author Erwin
 * 
 */
public class TransactionMode {
	/**
	 * 
	 */
	public static final TransactionMode READONLY = new TransactionMode(true);

	/**
	 * 
	 */
	public static final TransactionMode UPDATE = new TransactionMode(false);

	/**
	 * Gets The appropriate TransactionMode object for the given read-only setting
	 * 
	 * @param readOnly
	 *            The read-only status
	 * @return The appropriate TransactionMode object for the given read-only setting
	 */
	public static TransactionMode getTransactionMode (boolean readOnly) {
		return readOnly ? READONLY : UPDATE;
	}

	/**
	 * the readOnly status of this transaction mode
	 */
	private boolean readOnly;

	/**
	 * Creates the TransactionMode
	 * 
	 * @param readOnly
	 *            the readOnly status of this transaction mode
	 */
	private TransactionMode (boolean readOnly) {
		this.readOnly = readOnly;
	}

	/**
	 * Gets the readOnly status of this transaction mode
	 * 
	 * @return the readOnly status of this transaction mode
	 */
	public final boolean isReadOnly ( ) {
		return readOnly;
	}
}
