/*
 * Created on 9-jan-2009
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.util.IntersectableMap;

/**
 * A Tuple is a set of named attribute values. Values can thus be "read" from the tuple by providing the attribute name.
 * 
 * @author Erwin Smout
 */
public interface Tuple {

	/**
	 * Gets The attribute value for the named attribute
	 * 
	 * @param attributeName
	 *            The name of the attribute whose value is to be obtained
	 * @return The attribute value including the SIRA_PRISE escape sequences
	 */
	String escapedValue (String attributeName);

	/**
	 * Gets the heading that the Tuple conforms to
	 * 
	 * @return the heading that the Tuple conforms to
	 */
	Heading getHeading ( );

	/**
	 * Gets the tuple body value in textual format (i.e. attr1(value1)attr2(value2) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 * 
	 * @return the tuple body value in textual format (i.e. attr1(value1)attr2(value2) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 */
	String printBodyValueWithoutTypeNames ( );

	/**
	 * Gets the tuple body value in textual format (i.e. attr1(value1)attr2(value2) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 * 
	 * @return the tuple body value in textual format (i.e. attr1(value1)attr2(value2) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 */
	String printBodyValueWithTypeNames ( );

	/**
	 * Gets the tuple body value in textual XML-style format (i.e. <attr1>value1 </attr1> <attr2>value2 </attr2>)
	 * 
	 * @return The tuple body value in textual XML-style format (i.e. <attr1>value1 </attr1> <attr2>value2 </attr2>)
	 */
	String printBodyValueXML ( );

	/**
	 * Gets the tuple body value in textual format (i.e. attr1(value1)attr2(value2), INCLUDING escape processing for the ()\ characters of the metalanguage that appear in a printed value
	 * 
	 * @return the tuple body value in textual format (i.e. attr1(value1)attr2(value2), INCLUDING escape processing for the ()\ characters of the metalanguage that appear in a printed value
	 */
	String printEscapedBodyValueWithoutTypeNames ( );

	/**
	 * Gets the tuple body value in textual format (i.e. attr1(value1)attr2(value2), INCLUDING escape processing for the ()\ characters of the metalanguage that appear in a printed value
	 * 
	 * @return the tuple body value in textual format (i.e. attr1(value1)attr2(value2), INCLUDING escape processing for the ()\ characters of the metalanguage that appear in a printed value
	 */
	String printEscapedBodyValueWithTypeNames ( );

	/**
	 * Gets the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) INCLUDING escape processing for the ()\ characters of the metalanguage
	 * 
	 * @return the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) INCLUDING escape processing for the ()\ characters of the metalanguage
	 */
	String printValueEscapedWithoutTypeNames ( );

	/**
	 * Gets the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) INCLUDING escape processing for the ()\ characters of the metalanguage
	 * 
	 * @return the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) INCLUDING escape processing for the ()\ characters of the metalanguage
	 */
	String printValueEscapedWithTypeNames ( );

	/**
	 * Gets the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 * 
	 * @return the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 */
	String printValueWithoutTypeNames ( );

	/**
	 * Gets the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 * 
	 * @return the tuple value in textual format (i.e. TUPLE(attr1(value1)attr2(value2)) with value1, value2, ... NOT naming the type (i.e. 1 instead of INT(1))
	 */
	String printValueWithTypeNames ( );

	/**
	 * Gets the tuple value in textual XML-style format (i.e. <Tuple><attr1>value1 </attr1> <attr2>value2 </attr2> </Tuple>
	 * 
	 * @return The tuple value in textual XML-style format (i.e. <Tuple><attr1>value1 </attr1> <attr2>value2 </attr2> </Tuple>
	 */
	String printValueXML ( );

	/**
	 * Gets The attribute value for a relation-valued attribute, as a Relation object
	 * 
	 * @param attributeName
	 *            The name of the attribute whose value is to be obtained. This attribute must be declared nonscalar in the heading.
	 * @return The attribute value
	 */
	AbstractRelation rvaValue (String attributeName);

	/**
	 * Gets The attribute value for the named attribute
	 * 
	 * @param attributeName
	 *            The name of the attribute whose value is to be obtained
	 * @return The attribute value with SIRA_PRISE escape sequences removed
	 */
	String value (String attributeName);

	/**
	 * Gets the map of attribute values
	 * 
	 * @return the map of attribute values
	 */
	IntersectableMap<?, ?> values ( );
}