/*
 * Created on 13-okt-2008
 */
package be.SIRAPRISE.client;

/**
 * A TypeDeclaration corresponds to an attributeName in a Heading, and defines the type that the named attribute is of
 * 
 * @author Erwin Smout
 */
public interface TypeDeclaration {

	/**
	 * Gets the name of the type
	 * 
	 * @return Returns the typeName.
	 */
	String getTypeName ( );

	/**
	 * Checks whether the declared type is scalar
	 * 
	 * @return true if the declared type is scalar
	 */
	boolean isScalar ( );

	/**
	 * Gets the Heading (i.e. the relation or tuple type) of a nonscalar type declaration
	 * 
	 * @return the Heading (i.e. the relation or tuple type) of a nonscalar type declaration
	 * @throws TypeIsScalarException
	 *             if the type is scalar
	 */
	Heading getHeading ( ) throws TypeIsScalarException;
}