/*
 * Created on 13-jan-2009
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.NoUpdatesException;

/**
 * An abstract class that can be inherited from by classes that need to implement UpdatableDBObject, providing default implementations for the Java/SIRA_PRISE bridge methods
 * 
 * @author Erwin Smout
 */
public abstract class AbstractUpdatableDBObject extends AbstractDBObject implements UpdatableDBObject {

	/**
	 * Gets the command for Updating an entry in the named relvar (in the database the transaction is connected to), for the given object. The tuple that is updated in the database is constructed by invoking all the object's methods that satisfy the following properties :
	 * <ul>
	 * <li>The name of the method is the word "get" (all lowercase), followed by the capitalized relvar name (i.e. first character of the relvar name uppercase, all remaining characters of the relvar name lowercase), followed by a capitalized attribute name (i.e. the first character of the remaining part of the method name must be uppercase and all the other remaining characters must be lowercase)</LI>
	 * <li>The method is a public method that takes no arguments</LI>
	 * <li>The return type of the method is java.lang.String</LI>
	 * <li>The method is unique in the object's class for any given attribute name.</LI>
	 * </UL>
	 * The updates carried out are determined as follows : For each attribute in the tuple, the value for that attribute (obtained through invoking its getter method on the object) is compared to the pre-update value of that attribute (this value is obtained by invoking the same getter method on the result of the getPreUpdateState() method invocation on the object). If those are equal, nothing is done. If those values are unequal, then an entry is inserted in the update command to make sure the update for that attribute value will happen.
	 * 
	 * @param relvarName
	 *            The name of the relvar into which a tuple is to be added for the given object
	 * @param o
	 *            The object from which the tuple to be registered in the named relvar is to be drawn.
	 * @return the command for Updating an entry in the named relvar (in the database the transaction is connected to), for the given object.
	 * @throws NoUpdatesException
	 *             if no attribute value changes at all are detected
	 */
	public static DmlUpdateCommand dbUpdateCommand (String relvarName, UpdatableDBObject o) throws NoUpdatesException {
		return new DmlUpdateCommand(relvarName, o);
	}

	/**
	 * Gets the command for Updating an entry in the named relvar (in the database the transaction is connected to), for this DBObject. The tuple that is updated in the database is constructed by invoking all the object's methods that satisfy the following properties :
	 * <ul>
	 * <li>The name of the method is the word "get" (all lowercase), followed by the capitalized relvar name (i.e. first character of the relvar name uppercase, all remaining characters of the relvar name lowercase), followed by a capitalized attribute name (i.e. the first character of the remaining part of the method name must be uppercase and all the other remaining characters must be lowercase)</LI>
	 * <li>The method is a public method that takes no arguments</LI>
	 * <li>The return type of the method is java.lang.String</LI>
	 * <li>The method is unique in the object's class for any given attribute name.</LI>
	 * </UL>
	 * The updates carried out are determined as follows : For each attribute in the tuple, the value for that attribute (obtained through invoking its getter method on the object) is compared to the pre-update value of that attribute (this value is obtained by invoking the same getter method on the result of the getPreUpdateState() method invocation on the object). If those are equal, nothing is done. If those values are unequal, then an entry is inserted in the update command to make sure the update for that attribute value will happen.
	 * 
	 * @param relvarName
	 *            The name of the relvar into which a tuple is to be added for the given object
	 * @return the command for Updating an entry in the named relvar (in the database the transaction is connected to), for this DBObject.
	 * @throws NoUpdatesException
	 *             if no attribute value changes at all are detected
	 */
	public final DmlUpdateCommand dbUpdateCommand (String relvarName) throws NoUpdatesException {
		return new DmlUpdateCommand(relvarName, this);
	}

}