/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
final class AnnotatedMethodInvoker extends JSBAMethodInvoker {

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromObject extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromObject
		 * 
		 * @param method
		 */
		StringProducerFromObject (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		public String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return getMethod().invoke(o, objects).toString();
			//REMIND this does not get to the returned type's toString method, but to Object.toString() instead.
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromString extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromString
		 * 
		 * @param method
		 */
		StringProducerFromString (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		public String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return (String) getMethod().invoke(o, objects);
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromDouble extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromDouble
		 * 
		 * @param method
		 */
		StringProducerFromDouble (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Double) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromFloat extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromFloat
		 * 
		 * @param method
		 */
		StringProducerFromFloat (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Float) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromLong extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromLong
		 * 
		 * @param method
		 */
		StringProducerFromLong (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Long) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromInt extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromInt
		 * 
		 * @param method
		 */
		StringProducerFromInt (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Integer) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromShort extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromShort
		 * 
		 * @param method
		 */
		StringProducerFromShort (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Short) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static abstract class StringProducerFromNative {

		/**
		 * 
		 */
		private Method method;

		/**
		 * Creates the StringProducerFromNative
		 * 
		 * @param method
		 */
		StringProducerFromNative (Method method) {
			this.method = method;
		}

		/**
		 * Gets method
		 * 
		 * @return method.
		 */
		final Method getMethod ( ) {
			return method;
		}

		/**
		 * @param o
		 * @param objects
		 * @return
		 * @throws InvocationTargetException
		 * @throws IllegalAccessException
		 * @throws IllegalArgumentException
		 */
		abstract String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromChar extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromChar
		 * 
		 * @param method
		 */
		StringProducerFromChar (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Character) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * @author Erwin
	 * 
	 */
	static final class StringProducerFromByte extends StringProducerFromNative {

		/**
		 * Creates the StringProducerFromByte
		 * 
		 * @param method
		 */
		StringProducerFromByte (Method method) {
			super(method);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.SIRAPRISE.client.jsba.AnnotatedMethodInvoker.StringProducerFromNative#produce(java.lang.Object, java.lang.Object[])
		 */
		@Override
		String produce (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
			return ((Byte) getMethod().invoke(o, objects)).toString();
		}

	}

	/**
	 * 
	 */
	StringProducerFromNative stringProducer;

	/**
	 * 
	 */
	boolean escapingWrapper;

	/**
	 * Creates the AnnotatedMethodInvoker
	 * 
	 * @param method
	 * @param jsbaGetterMethodAnnotation
	 * @param relvarNameIndexInAnnotation
	 */
	AnnotatedMethodInvoker (Method method, GetterMethod jsbaGetterMethodAnnotation, int relvarNameIndexInAnnotation) {
		Class<?> methodReturnType = method.getReturnType();
		// TODO deal with the method return type : provide all toString converters for all possible java native types & classes
		if (methodReturnType.isPrimitive()) {
			if (methodReturnType == byte.class) {
				stringProducer = new StringProducerFromByte(method);
			} else {
				if (methodReturnType == char.class) {
					stringProducer = new StringProducerFromChar(method);
				} else {
					if (methodReturnType == short.class) {
						stringProducer = new StringProducerFromShort(method);
					} else {
						if (methodReturnType == int.class) {
							stringProducer = new StringProducerFromInt(method);
						} else {
							if (methodReturnType == long.class) {
								stringProducer = new StringProducerFromLong(method);
							} else {
								if (methodReturnType == float.class) {
									stringProducer = new StringProducerFromFloat(method);
								} else {
									if (methodReturnType == double.class) {
										stringProducer = new StringProducerFromDouble(method);
									} else {
										throw new IllegalArgumentException(methodReturnType.getName());
									}
								}
							}
						}
					}
				}
			}
		} else {
			if (methodReturnType == String.class) {
				stringProducer = new StringProducerFromString(method);
			} else {
				stringProducer = new StringProducerFromObject(method);
			}
		}

		final boolean[] requiresEscaping = jsbaGetterMethodAnnotation.requiresEscaping();
		if (requiresEscaping.length == 1) {
			escapingWrapper = requiresEscaping[0];
		} else {
			escapingWrapper = requiresEscaping[relvarNameIndexInAnnotation];
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.JSBAMethodInvoker#invoke(java.lang.Object, java.lang.Object[])
	 */
	@Override
	public String invoke (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		String s = stringProducer.produce(o, objects);
		return escapingWrapper ? BracketParser.meta(s) : s;
	}
}
