/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "AssignmentConstraint","ConstraintMessageText" })
public final class AssignmentConstraint extends AbstractUpdatableDBObject implements DBObjectToAssignmentconstraint, AssignmentconstraintToDBObject, DBObjectToConstraintmessagetext, ConstraintmessagetextToDBObject {

	/**
	 * The constraint expression
	 */
	private String constraintExpression;

	/**
	 * The constraint label
	 */
	private String constraintLabel;

	/**
	 * The corresponding constraint message text, if any
	 */
	private String constraintMessageText = ""; //$NON-NLS-1$

	/**
	 * Comment for <code>errorCode</code>
	 */
	private long errorCode;

	/**
	 * The pre-update state
	 */
	private AssignmentConstraint preUpdateState;

	/**
	 * Creates the AssignmentConstraint
	 */
	public AssignmentConstraint ( ) {

	}

	/**
	 * Creates the AssignmentConstraint
	 * 
	 * @param constraintExpression
	 *            The constraint expression
	 * @param errorCode
	 *            The page size
	 * @param constraintLabel
	 *            The constraint label
	 */
	public AssignmentConstraint (String constraintExpression, long errorCode, String constraintLabel) {
		this.constraintExpression = constraintExpression;
		this.errorCode = errorCode;
		this.constraintLabel = constraintLabel;
	}

	/**
	 * Creates the AssignmentConstraint
	 * 
	 * @param constraintExpression
	 *            The file name
	 * @param errorCode
	 *            The page size
	 * @param constraintLabel
	 *            The constraint label
	 * @param constraintMessageText
	 *            The constraint message text to be displayed in the event of violations
	 */
	public AssignmentConstraint (String constraintExpression, long errorCode, String constraintLabel, String constraintMessageText) {
		this(constraintExpression, errorCode, constraintLabel);
		this.constraintMessageText = constraintMessageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraint#getAssignmentconstraintConstraintlabel()
	 */
	public String getAssignmentconstraintConstraintlabel ( ) {
		return BracketParser.meta(constraintLabel);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraint#getAssignmentconstraintErrorcode()
	 */
	public String getAssignmentconstraintErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraint#getAssignmentconstraintSp_expression()
	 */
	public String getAssignmentconstraintSp_expression ( ) {
		return BracketParser.meta(constraintExpression);
	}

	/**
	 * Gets The constraint expression
	 * 
	 * @return The constraint expression.
	 */
	public final String getConstraintExpression ( ) {
		return constraintExpression;
	}

	/**
	 * Gets The constraint label
	 * 
	 * @return The constraint label.
	 */
	public final String getConstraintLabel ( ) {
		return constraintLabel;
	}

	/**
	 * Gets The corresponding constraint message text, if any
	 * 
	 * @return The corresponding constraint message text, if any
	 */
	public final String getConstraintMessageText ( ) {
		return constraintMessageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextConstraintmessagetext()
	 */
	public String getConstraintmessagetextConstraintmessagetext ( ) {
		return constraintMessageText == null ? "" : BracketParser.meta(constraintMessageText); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextErrorcode()
	 */
	public String getConstraintmessagetextErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/**
	 * @return Returns the errorCode.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Sets The constraint expression
	 * 
	 * @param constraintExpression
	 *            The constraintExpression to set.
	 */
	public final void setConstraintExpression (String constraintExpression) {
		this.constraintExpression = constraintExpression;
	}

	/**
	 * Sets The constraint label
	 * 
	 * @param constraintLabel
	 *            The constraintLabel to set.
	 */
	public final void setConstraintLabel (String constraintLabel) {
		this.constraintLabel = constraintLabel;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintToDBObject#setConstraintlabelFromDB(java.lang.String)
	 */
	public void setConstraintlabelFromDB (String constraintlabel) {
		try {
			this.constraintLabel = BracketParser.unMeta(constraintlabel);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The corresponding constraint message text, if any
	 * 
	 * @param constraintMessageText
	 *            The constraintMessageText to set.
	 */
	public final void setConstraintMessageText (String constraintMessageText) {
		this.constraintMessageText = constraintMessageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstraintmessagetextToDBObject#setConstraintmessagetextFromDB(java.lang.String)
	 */
	public void setConstraintmessagetextFromDB (String constraintmessagetext) {
		try {
			this.constraintMessageText = BracketParser.unMeta(constraintmessagetext);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * @param errorCode
	 *            The errorCode to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintToDBObject#setErrorcodeFromDB(java.lang.String)
	 */
	public void setErrorcodeFromDB (String errorcode) {
		this.errorCode = Long.parseLong(errorcode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new AssignmentConstraint(constraintExpression, errorCode, constraintLabel, constraintMessageText);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String sp_expression) {
		try {
			this.constraintExpression = BracketParser.unMeta(sp_expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Gets a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state. The "smart" update command consists of :
	 * <ul>
	 * <li>optionally (if and only if any changes were applied to the error code or constraintexpression attributes), an update command for the TUPLECONSTRAINT relvar.</li>
	 * <li>optionally (if and only if any changes were applied to the error code or constraint message text), one of the following to update the CONSTRAINTMESSAGETEXT relvar :
	 * <ul>
	 * <li>a DELETE if the preUpdateState message text was non-null and non-empty, but the new message text is null or the empty string.</li>
	 * <li>a INSERT if the preUpdateState message text was null or empty, but the new message text is non-null and a non-empty string.</li>
	 * <li>an UPDATE if the preUpdateState message text was non-null and non-empty, and the new message text is non-null and a non-empty string, and it is the case that either the message text or the error code has changed.</li>
	 * </ul>
	 * </li>
	 * </ul>
	 * 
	 * @return a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state.
	 * @throws NoUpdatesException
	 *             If there are no differences between the pre-update and the current state
	 */
	public DmlAssignmentCommand[] smartUpdateCommand ( ) throws NoUpdatesException {
		DmlAssignmentCommand[] cmds;
		AssignmentConstraint oldAssignmentConstraint = (AssignmentConstraint) getPreUpdateState();
		String oldConstraintMessageText = oldAssignmentConstraint.constraintMessageText;
		final boolean noNewMessageText = constraintMessageText == null || constraintMessageText.trim().length() == 0;
		final boolean noOldMessageText = oldConstraintMessageText == null || oldConstraintMessageText.trim().length() == 0;

		try {
			DmlUpdateCommand cmd1 = dbUpdateCommand(RELVARNAMES.ASSIGNMENTCONSTRAINT);
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update AssignmentConstraint
					cmds = new DmlAssignmentCommand[] { cmd1 };
				} else {
					// now present, update AssignmentConstraint plus add
					cmds = new DmlAssignmentCommand[] { cmd1, dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update AssignmentConstraint plus delete
					cmds = new DmlAssignmentCommand[] { cmd1, oldAssignmentConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				} else {
					// still present, update AssignmentConstraint plus MessageText
					try {
						cmds = new DmlAssignmentCommand[] { cmd1, dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
					} catch (NoUpdatesException e) {
						cmds = new DmlAssignmentCommand[] { cmd1 };
					}
				}
			}
		} catch (NoUpdatesException e1) {
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update AssignmentConstraint (which means : nothing to do)
					throw e1;
				} else {
					// now present, update AssignmentConstraint plus add
					cmds = new DmlAssignmentCommand[] { dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update AssignmentConstraint plus delete
					cmds = new DmlAssignmentCommand[] { oldAssignmentConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
				} else {
					// still present, update AssignmentConstraint plus MessageText
					try {
						cmds = new DmlAssignmentCommand[] { dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) };
					} catch (NoUpdatesException e) {
						throw e1;
					}
				}
			}
		}
		return cmds;
	}
}