/**
 * 
 */
package be.SIRAPRISE.client.jsba;


/**
 * @author Erwin
 */
@ForRelvars(relvarNames = { "AssignmentConstraintCheck" })
public final class AssignmentConstraintCheck extends AbstractUpdatableDBObject implements AssignmentconstraintcheckToDBObject, DBObjectToAssignmentconstraintcheck {

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private int operationType;

	/**
	 * 
	 */
	private AssignmentConstraintCheck preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the AssignmentConstraintCheck
	 */
	public AssignmentConstraintCheck ( ) {
		this("", -1, -1); //$NON-NLS-1$
	}

	/**
	 * Creates the AssignmentConstraintCheck
	 * 
	 * @param relvarName
	 * @param operationType
	 * @param errorCode
	 */
	public AssignmentConstraintCheck (String relvarName, int operationType, long errorCode) {
		this.relvarName = relvarName.toUpperCase();
		this.operationType = operationType;
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraintcheck#getAssignmentconstraintcheckErrorcode()
	 */
	@Override
	public String getAssignmentconstraintcheckErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraintcheck#getAssignmentconstraintcheckOperationtype()
	 */
	@Override
	public String getAssignmentconstraintcheckOperationtype ( ) {
		return Integer.toString(operationType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAssignmentconstraintcheck#getAssignmentconstraintcheckRelvarname()
	 */
	@Override
	public String getAssignmentconstraintcheckRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Gets errorCode
	 * 
	 * @return errorCode.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/**
	 * Gets operationType
	 * 
	 * @return operationType.
	 */
	public final int getOperationType ( ) {
		return operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets errorCode
	 * 
	 * @param errorCode
	 *            The errorCode to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintcheckToDBObject#setErrorcodeFromDB(java.lang.String)
	 */
	@Override
	public void setErrorcodeFromDB (String errorcode) {
		this.errorCode = Long.parseLong(errorcode);
	}

	/**
	 * Sets operationType
	 * 
	 * @param operationType
	 *            The operationType to set.
	 */
	public final void setOperationType (int operationType) {
		this.operationType = operationType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintcheckToDBObject#setOperationtypeFromDB(java.lang.String)
	 */
	@Override
	public void setOperationtypeFromDB (String operationtype) {
		this.operationType = Integer.parseInt(operationtype);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new AssignmentConstraintCheck(relvarName, operationType, errorCode);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AssignmentconstraintcheckToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

}
