/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "Attribute","AttributeLogicalLength" })
public final class Attribute extends AbstractUpdatableDBObject implements DBObjectToAttribute, AttributeToDBObject, DBObjectToAttributelogicallength, AttributelogicallengthToDBObject {

	/**
	 * The logical length, or -1 if not applicable or not set
	 */
	private int logicalLength = -1;

	/**
	 * The attribute name
	 */
	private String name;

	/**
	 * The pre-update state
	 */
	private Attribute preUpdateState;

	/**
	 * The type name
	 */
	private String typeName;

	/**
	 * Creates an empty Attribute
	 */
	public Attribute() {

	}

	/**
	 * Creates the Attribute
	 * 
	 * @param attributeName
	 *            The attribute name
	 * @param typeName
	 *            The type name
	 * @param logicalLength
	 *            The logical length, or -1 if not applicable or unknown or irrelevant
	 */
	public Attribute(String attributeName, String typeName, int logicalLength) {
		this.name = attributeName;
		this.typeName = typeName;
		this.logicalLength = logicalLength;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttribute#getAttributeSp_expression()
	 */
	public final String getAttributeAttributename() {
		return BracketParser.meta(name);
	}

	public String getAttributelogicallengthAttributename() {
		return BracketParser.meta(name);
	}

	public String getAttributelogicallengthLogicallength() {
		return Long.toString(logicalLength);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttribute#getAttributeConstraintlabel()
	 */
	public final String getAttributeTypename() {
		return BracketParser.meta(typeName);
	}

	/**
	 * Gets The logical length, or -1 if this doen't apply
	 * 
	 * @return The logical length, or -1 if this doen't apply
	 */
	public final int getLogicalLength() {
		return logicalLength;
	}

	/**
	 * Gets The attribute name
	 * 
	 * @return The attribute name.
	 */
	public final String getName() {
		return name;
	}

	public final UpdatableDBObject getPreUpdateState() {
		return preUpdateState;
	}

	/**
	 * Gets The type name
	 * 
	 * @return The type name.
	 */
	public final String getTypeName() {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributeToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	public final void setAttributenameFromDB(String attributeName) {
		try {
			this.name = BracketParser.unMeta(attributeName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The logicalLength
	 * 
	 * @param logicalLength
	 *            The logicalLength to set.
	 */
	public final void setLogicalLength(int logicalLength) {
		this.logicalLength = logicalLength;
	}

	public void setLogicallengthFromDB(String logicalLength) {
		this.logicalLength = Integer.parseInt(logicalLength);
	}

	/**
	 * Sets The attribute name
	 * 
	 * @param attributeName
	 *            The attributeName to set.
	 */
	public final void setName(String attributeName) {
		this.name = attributeName.toUpperCase();
	}

	public final void setPreUpdateState() {
		preUpdateState = new Attribute(getName(), getTypeName(), logicalLength);
	}

	/**
	 * Sets The type name
	 * 
	 * @param typeName
	 *            The typeName to set.
	 */
	public final void setTypeName(String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributeToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public final void setTypenameFromDB(String typeName) {
		try {
			this.typeName = BracketParser.unMeta(typeName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}
}