/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "AttributeValueDistribution" })
public final class AttributeValueDistribution extends AbstractUpdatableDBObject implements AttributevaluedistributionToDBObject, DBObjectToAttributevaluedistribution {

	/**
	 * 
	 */
	private String attributeName;

	/**
	 * 
	 */
	private double frequency;

	/**
	 * 
	 */
	private AttributeValueDistribution preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * 
	 */
	private double standardDeviation;

	/**
	 * 
	 */
	private int valueCount;

	/**
	 * Creates the AttributeValueDistribution
	 * 
	 */
	public AttributeValueDistribution ( ) {
		this.relvarName = ""; //$NON-NLS-1$
		this.attributeName = ""; //$NON-NLS-1$
		this.valueCount = -1;
		this.frequency = -1;
		this.standardDeviation = -1;
	}

	/**
	 * Creates the AttributeValueDistribution
	 * 
	 * @param relvarName
	 * @param attributeName
	 * @param valueCount
	 * @param frequency
	 * @param standardDeviation
	 */
	public AttributeValueDistribution (String relvarName, String attributeName, int valueCount, double frequency, double standardDeviation) {
		this.relvarName = relvarName.toUpperCase();
		this.attributeName = attributeName.toUpperCase();
		this.valueCount = valueCount;
		this.frequency = frequency;
		this.standardDeviation = standardDeviation;
	}

	/**
	 * Gets attributeName
	 * 
	 * @return attributeName.
	 */
	public final String getAttributeName ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttributevaluedistribution#getAttributevaluedistributionAttributename()
	 */
	public String getAttributevaluedistributionAttributename ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttributevaluedistribution#getAttributevaluedistributionFrequency()
	 */
	public String getAttributevaluedistributionFrequency ( ) {
		return Double.toString(frequency);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttributevaluedistribution#getAttributevaluedistributionRelvarname()
	 */
	public String getAttributevaluedistributionRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttributevaluedistribution#getAttributevaluedistributionStddev()
	 */
	public String getAttributevaluedistributionStddev ( ) {
		return Double.toString(standardDeviation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToAttributevaluedistribution#getAttributevaluedistributionValuecount()
	 */
	public String getAttributevaluedistributionValuecount ( ) {
		return Integer.toString(valueCount);
	}

	/**
	 * Gets frequency
	 * 
	 * @return frequency.
	 */
	public final double getFrequency ( ) {
		return frequency;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Gets standardDeviation
	 * 
	 * @return standardDeviation.
	 */
	public final double getStandardDeviation ( ) {
		return standardDeviation;
	}

	/**
	 * Gets valueCount
	 * 
	 * @return valueCount.
	 */
	public final int getValueCount ( ) {
		return valueCount;
	}

	/**
	 * Sets attributeName
	 * 
	 * @param attributeName
	 *            The attributeName to set.
	 */
	public final void setAttributeName (String attributeName) {
		this.attributeName = attributeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributevaluedistributionToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	public void setAttributenameFromDB (String attributename) {
		this.attributeName = attributename.toUpperCase();
	}

	/**
	 * Sets frequency
	 * 
	 * @param frequency
	 *            The frequency to set.
	 */
	public final void setFrequency (double frequency) {
		this.frequency = frequency;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributevaluedistributionToDBObject#setFrequencyFromDB(java.lang.String)
	 */
	public void setFrequencyFromDB (String frequency) {
		this.frequency = Double.parseDouble(frequency);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new AttributeValueDistribution(relvarName, attributeName, valueCount, frequency, standardDeviation);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributevaluedistributionToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

	/**
	 * Sets standardDeviation
	 * 
	 * @param standardDeviation
	 *            The standardDeviation to set.
	 */
	public final void setStandardDeviation (double standardDeviation) {
		this.standardDeviation = standardDeviation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributevaluedistributionToDBObject#setStddevFromDB(java.lang.String)
	 */
	public void setStddevFromDB (String stddev) {
		this.standardDeviation = Double.parseDouble(stddev);
	}

	/**
	 * Sets valueCount
	 * 
	 * @param valueCount
	 *            The valueCount to set.
	 */
	public final void setValueCount (int valueCount) {
		this.valueCount = valueCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.AttributevaluedistributionToDBObject#setValuecountFromDB(java.lang.String)
	 */
	public void setValuecountFromDB (String valuecount) {
		this.valueCount = Integer.parseInt(valuecount);
	}

}
