/*
 * Created on 14-jan-2009
 */
package be.SIRAPRISE.client.jsba;

/**
 * ClassDoesNotImplementDBObjectExceptions are thrown by the JSBA if it detects that a Class object passed as an argument to one of the JSBA methods, does not implement the required interface.
 * 
 * @author Erwin Smout
 */
public final class ClassDoesNotImplementDBObjectException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6704464033975214809L;

	/**
	 * Creates the exception, setting the concerned classname as its message
	 * 
	 * @param objectClass
	 *            The Class object representing the class whose lack of implementing DBObject caused this exception to be thrown
	 */
	public ClassDoesNotImplementDBObjectException (Class<?> objectClass) {
		super(objectClass.getName());
	}

}
