/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "Client" })
public final class Client extends AbstractUpdatableDBObject implements DBObjectToClient, ClientToDBObject {

	/**
	 * 
	 */
	private String ID;

	/**
	 * 
	 */
	private Client preUpdateState;

	/**
	 * 
	 */
	private boolean trustAuthentications;

	/**
	 * Creates the Client
	 */
	public Client ( ) {
		this("", false); //$NON-NLS-1$
	}

	/**
	 * Creates the Client
	 * 
	 * @param clientID
	 * @param trustAuthentications
	 */
	public Client (String clientID, boolean trustAuthentications) {
		this.ID = clientID.toUpperCase();
		this.trustAuthentications = trustAuthentications;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToClient#getClientClient()
	 */
	@Override
	public String getClientClientid ( ) {
		return ID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToClient#getClientTrustauthentication()
	 */
	@Override
	public String getClientTrustauthentication ( ) {
		return Boolean.toString(trustAuthentications);
	}

	/**
	 * Gets clientID
	 * 
	 * @return clientID.
	 */
	public final String getID ( ) {
		return ID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets trustAuthentications
	 * 
	 * @return trustAuthentications.
	 */
	public final boolean isTrustAuthentications ( ) {
		return trustAuthentications;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ClientToDBObject#setClientFromDB(java.lang.String)
	 */
	@Override
	public void setClientidFromDB (String client) {
		this.ID = client.toUpperCase();
	}

	/**
	 * Sets clientID
	 * 
	 * @param clientID
	 *            The clientID to set.
	 */
	public final void setID (String clientID) {
		this.ID = clientID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new Client(ID, trustAuthentications);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ClientToDBObject#setTrustauthenticationFromDB(java.lang.String)
	 */
	@Override
	public void setTrustauthenticationFromDB (String trustauthentication) {
		this.trustAuthentications = Boolean.parseBoolean(trustauthentication);
	}

	/**
	 * Sets trustAuthentications
	 * 
	 * @param trustAuthentications
	 *            The trustAuthentications to set.
	 */
	public final void setTrustAuthentications (boolean trustAuthentications) {
		this.trustAuthentications = trustAuthentications;
	}

}
