/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "ConstrainedType" })
public final class ConstrainedType extends AbstractUpdatableDBObject implements DBObjectToConstrainedtype, ConstrainedtypeToDBObject {

	/**
	 * The base type's name
	 */
	private String baseTypeName;

	/**
	 * The constraint expression
	 */
	private String expression;

	/**
	 * The pre-update state
	 */
	private ConstrainedType preUpdateState;

	/**
	 * The type name
	 */
	private String typeName;

	/**
	 * Creates an empty ConstrainedType
	 */
	public ConstrainedType() {

	}

	/**
	 * Creates the ConstrainedType
	 * @param typeName
	 *            The type name
	 * @param baseTypeName
	 *            The constraint message text to be displayed in the event of violations
	 * @param expression
	 *            The file name
	 */
	public ConstrainedType(String typeName, String baseTypeName, String expression) {
		this.typeName = typeName.toUpperCase();
		this.baseTypeName = baseTypeName.toUpperCase();
		this.expression = expression;
	}

	/**
	 * Gets The base type's name
	 * 
	 * @return The base type's name
	 */
	public final String getBaseTypeName() {
		return baseTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstrainedtype#getConstrainedtypeBasetype()
	 */
	public String getConstrainedtypeBasetype() {
		return baseTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstrainedtype#getConstrainedtypeSp_expression()
	 */
	public String getConstrainedtypeSp_expression() {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstrainedtype#getConstrainedtypeConstraintlabel()
	 */
	public String getConstrainedtypeTypename() {
		return typeName;
	}

	/**
	 * Gets The constraint expression
	 * 
	 * @return The constraint expression.
	 */
	public final String getExpression() {
		return expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState() {
		return preUpdateState;
	}

	/**
	 * Gets The type name
	 * 
	 * @return The type name.
	 */
	public final String getTypeName() {
		return typeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstrainedtypeToDBObject#setBasetypeFromDB(java.lang.String)
	 */
	public void setBasetypeFromDB(String basetype) {
		this.baseTypeName = basetype.toUpperCase();
	}

	/**
	 * Sets The base type's name
	 * 
	 * @param baseTypeName
	 *            The baseTypeName to set.
	 */
	public final void setBaseTypeName(String baseTypeName) {
		this.baseTypeName = baseTypeName.toUpperCase();
	}

	/**
	 * Sets The constraint expression
	 * 
	 * @param expression
	 *            The expression to set.
	 */
	public final void setExpression(String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstrainedtypeToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB(String expression) {
		try {
			this.expression = BracketParser.unMeta(expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState() {
		preUpdateState = new ConstrainedType(typeName, baseTypeName, expression);
	}

	/**
	 * Sets The type name
	 * 
	 * @param typeName
	 *            The typeName to set.
	 */
	public final void setTypeName(String typeName) {
		this.typeName = typeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstrainedtypeToDBObject#setTypenameFromDB(java.lang.String)
	 */
	public void setTypenameFromDB(String typeName) {
		this.typeName = typeName.toUpperCase();
	}
}