/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * The ConstructorFor annotation allows the jsba runtime to decide which constructor to use for building jsba objects from the tuples in a relation returned from a query.
 * 
 * The jsba runtime searches for and selects the constructor to use in the following order of preference :
 * <ol>
 * <li>A public constructor with a single argument of a type/class that implements the Tuple interface. It is the responsibility of the designer to ensure that only one such constructor exists. If more than one such constructor exists, results are unpredictable.</li>
 * <li>A public constructor annotated by a ConstructorFor annotation. The constructor selected will be the one that :
 * <ul>
 * <li>names a subset of the attributes present in the tuple's heading, i.e. no attributes are named in the annotation that are not present in the tuple</li>
 * <li>has the highest attribute count</li>
 * </ul>
 * It is the responsibility of the designer to ensure that only one such constructor exists (i.e. there cannot be 'draws' in terms of attribute count).  If more than one such constructors can be found, results are unpredictable.
 * </li>
 * <li>A public no-arg constructor.</li>
 * </ol>
 * 
 * @author Erwin
 * 
 */
public @interface ConstructorFor {

	/**
	 * The name(s) of the attributes to which the arguments in the annotated constructor correspond. There must be exactly as many attribute names in the annotation as there are arguments in the constructor.
	 */
	String[] attributeNames();

}
