/*
 * Created on 24-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "DataSpace", "StorageSpace" })
public final class DataSpace extends AbstractUpdatableDBObject implements DBObjectToDataspace, DBObjectToStoragespace, DataspaceToDBObject, StoragespaceToDBObject {

	/**
	 * The extents count
	 */
	private int extentsCount;

	/**
	 * The file name
	 */
	private String fileName;

	/**
	 * The gap compression threshold
	 */
	private int gapCompressionThreshold;

	/**
	 * The maximum gap count
	 */
	private int maximumGaps;

	/**
	 * The page count
	 */
	private int pageCount;

	/**
	 * The pre-update state
	 */
	private DataSpace preUpdateState;

	/**
	 * The ID
	 */
	private int storageSpaceID;

	/**
	 * 
	 */
	public DataSpace ( ) {

	}

	/**
	 * @param fileName
	 *            The file name
	 * @param storageSpaceID
	 *            The ID
	 * @param pageCount
	 *            The page count
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 * @param maximumGaps
	 *            The maximum gap count
	 */
	public DataSpace (String fileName, int storageSpaceID, int pageCount, int gapCompressionThreshold, int maximumGaps) {
		this.fileName = fileName.toUpperCase();
		this.storageSpaceID = storageSpaceID;
		this.pageCount = pageCount;
		this.gapCompressionThreshold = gapCompressionThreshold;
		this.maximumGaps = maximumGaps;
	}

	/**
	 * @param fileName
	 *            The file name
	 * @param storageSpaceID
	 *            The ID
	 * @param pageCount
	 *            The page count
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 * @param maximumGaps
	 *            The maximum gap count
	 * @param extentsCount
	 *            The extents count
	 */
	public DataSpace (String fileName, int storageSpaceID, int pageCount, int gapCompressionThreshold, int maximumGaps, int extentsCount) {
		this(fileName, storageSpaceID, pageCount, gapCompressionThreshold, maximumGaps);
		this.extentsCount = extentsCount;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getDataspaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets The gap compression threshold
	 * 
	 * @return The gap compression threshold
	 */
	public final String getDataspaceGapcompressionthreshold ( ) {
		return Integer.toString(gapCompressionThreshold);
	}

	/**
	 * Gets The gap compression threshold
	 * 
	 * @return The gap compression threshold
	 */
	public final String getDataspaceMaximumgaps ( ) {
		return Integer.toString(maximumGaps);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getDataspaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Gets The extents count
	 * 
	 * @return The extents count
	 */
	public final int getExtentsCount ( ) {
		return extentsCount;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * Gets The gap compression threshold
	 * 
	 * @return The gap compression threshold
	 */
	public final int getGapCompressionThreshold ( ) {
		return gapCompressionThreshold;
	}

	/**
	 * Gets The maximum gap count
	 * 
	 * @return The maximum gap count
	 */
	public final int getMaximumGaps ( ) {
		return maximumGaps;
	}

	/**
	 * Gets The page count
	 * 
	 * @return The page count
	 */
	public final int getPageCount ( ) {
		return pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceExtentscount()
	 */
	@Override
	public String getStoragespaceExtentscount ( ) {
		return Integer.toString(extentsCount);
	}

	/**
	 * Gets the extents count
	 * 
	 * @return the extents count
	 * @deprecated
	 */
	public final String getStoragespaceextentsExtentscount ( ) {
		return Integer.toString(extentsCount);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 * @deprecated
	 */
	public final String getStoragespaceextentsFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 * @deprecated
	 */
	public final String getStoragespaceextentsStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getStoragespaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/**
	 * Gets The page count
	 * 
	 * @return The page count
	 */
	public final String getStoragespacePagecount ( ) {
		return Integer.toString(pageCount);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getStoragespaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Sets The extents count
	 * 
	 * @param extentsCount
	 *            The extents count
	 */
	public final void setExtentsCount (int extentsCount) {
		this.extentsCount = extentsCount;
	}

	/**
	 * Sets The extents count
	 * 
	 * @param extentsCount
	 *            The extents count
	 */
	public final void setExtentscountFromDB (String extentsCount) {
		this.extentsCount = Integer.parseInt(extentsCount);
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFilenameFromDB (String fileName) {
		try {
			this.fileName = BracketParser.unMeta(fileName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The gap compression threshold
	 * 
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 */
	public final void setGapCompressionThreshold (int gapCompressionThreshold) {
		this.gapCompressionThreshold = gapCompressionThreshold;
	}

	/**
	 * Sets The gap compression threshold
	 * 
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 */
	public final void setGapcompressionthresholdFromDB (String gapCompressionThreshold) {
		this.gapCompressionThreshold = Integer.parseInt(gapCompressionThreshold);
	}

	/**
	 * Gets The maximum gap count
	 * 
	 * @param maximumGaps
	 *            The maximum gap count.
	 */
	public final void setMaximumGaps (int maximumGaps) {
		this.maximumGaps = maximumGaps;
	}

	/**
	 * Sets The maximum gap count
	 * 
	 * @param maximumGaps
	 *            The maximum gap count.
	 */
	public final void setMaximumgapsFromDB (String maximumGaps) {
		this.maximumGaps = Integer.parseInt(maximumGaps);
	}

	/**
	 * Sets The page count
	 * 
	 * @param pageCount
	 *            The page count
	 */
	public final void setPageCount (int pageCount) {
		this.pageCount = pageCount;
	}

	/**
	 * Sets The page count
	 * 
	 * @param pageCount
	 *            The page count
	 */
	public final void setPagecountFromDB (String pageCount) {
		this.pageCount = Integer.parseInt(pageCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new DataSpace(fileName, storageSpaceID, pageCount, gapCompressionThreshold, maximumGaps, extentsCount);
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStoragespaceidFromDB (String storageSpaceID) {
		this.storageSpaceID = Integer.parseInt(storageSpaceID);
	}
}