/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlMultipleAssignmentCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "DatabaseConstraint", "ConstraintMessageText" })
public final class DatabaseConstraint extends AbstractUpdatableDBObject implements DBObjectToDatabaseconstraint, DatabaseconstraintToDBObject, ConstraintmessagetextToDBObject, DBObjectToConstraintmessagetext {

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private String expression;

	/**
	 * 
	 */
	private String label;

	/**
	 * The corresponding messagetext to be generated upon violations of the constraint. null or a dash ("-") means "none".
	 */
	private String messageText;

	/**
	 * 
	 */
	private DatabaseConstraint preUpdateState;

	/**
	 * Creates the DatabaseConstraint
	 * 
	 */
	public DatabaseConstraint ( ) {
		this(-1, "", "", "-"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/**
	 * Creates the DatabaseConstraint
	 * 
	 * @param errorCode
	 * @param expression
	 * @param label
	 * @param messageText
	 *            the corresponding messagetext to be generated upon violations of the constraint. null or a dash ("-") means "none".
	 */
	public DatabaseConstraint (long errorCode, String expression, String label, String messageText) {
		this.errorCode = errorCode;
		this.expression = expression;
		this.label = label;
		this.messageText = messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextConstraintmessagetext()
	 */
	@Override
	public String getConstraintmessagetextConstraintmessagetext ( ) {
		return BracketParser.meta(messageText);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToConstraintmessagetext#getConstraintmessagetextErrorcode()
	 */
	@Override
	public String getConstraintmessagetextErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToDatabaseconstraint#getDatabaseconstraintConstraintlabel()
	 */
	@Override
	public String getDatabaseconstraintConstraintlabel ( ) {
		return BracketParser.meta(label);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToDatabaseconstraint#getDatabaseconstraintErrorcode()
	 */
	@Override
	public String getDatabaseconstraintErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToDatabaseconstraint#getDatabaseconstraintConstraintexpression()
	 */
	@Override
	public String getDatabaseconstraintSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/**
	 * Gets errorCode
	 * 
	 * @return errorCode.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/**
	 * Gets expression
	 * 
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/**
	 * Gets label
	 * 
	 * @return label.
	 */
	public final String getLabel ( ) {
		return label;
	}

	/**
	 * Gets messageText
	 * 
	 * @return messageText.
	 */
	public final String getMessageText ( ) {
		return messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DatabaseconstraintToDBObject#setConstraintlabelFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintlabelFromDB (String constraintlabel) {
		try {
			this.label = BracketParser.unMeta(constraintlabel);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.ConstraintmessagetextToDBObject#setConstraintmessagetextFromDB(java.lang.String)
	 */
	@Override
	public void setConstraintmessagetextFromDB (String constraintmessagetext) {
		try {
			this.messageText = BracketParser.unMeta(constraintmessagetext);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets errorCode
	 * 
	 * @param errorCode
	 *            The errorCode to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DatabaseconstraintToDBObject#setErrorcodeFromDB(java.lang.String)
	 */
	@Override
	public void setErrorcodeFromDB (String errorcode) {
		this.errorCode = Long.parseLong(errorcode);
	}

	/**
	 * Sets expression
	 * 
	 * @param expression
	 *            The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/**
	 * Sets label
	 * 
	 * @param label
	 *            The label to set.
	 */
	public final void setLabel (String label) {
		this.label = label;
	}

	/**
	 * Sets messageText
	 * 
	 * @param messageText
	 *            The corresponding messagetext to be generated upon violations of the constraint. null or a dash ("-") means "none".
	 */
	public final void setMessageText (String messageText) {
		this.messageText = messageText;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new DatabaseConstraint(errorCode, expression, label, messageText);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DatabaseconstraintToDBObject#setConstraintexpressionFromDB(java.lang.String)
	 */
	@Override
	public void setSp_expressionFromDB (String constraintexpression) {
		try {
			this.expression = BracketParser.unMeta(constraintexpression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Gets a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state. The "smart" update command consists of :
	 * <ul>
	 * <li>optionally (if and only if any changes were applied to the error code or constraintexpression attributes), an update command for the DATABASECONSTRAINT relvar.</li>
	 * <li>optionally (if and only if any changes were applied to the error code or constraint message text), one of the following to update the CONSTRAINTMESSAGETEXT relvar :
	 * <ul>
	 * <li>a DELETE if the preUpdateState message text was non-null and non-empty, but the new message text is null or the empty string.</li>
	 * <li>a INSERT if the preUpdateState message text was null or empty, but the new message text is non-null and a non-empty string.</li>
	 * <li>an UPDATE if the preUpdateState message text was non-null and non-empty, and the new message text is non-null and a non-empty string, and it is the case that either the message text or the error code has changed.</li>
	 * </ul>
	 * </li>
	 * </ul>
	 * 
	 * @return a "smart" update command that brings the catalog from the state reflected in preUpdateState, to the current state.
	 * @throws NoUpdatesException
	 *             If there are no differences between the pre-update and the current state
	 */
	public DmlAssignmentCommand smartUpdateComand ( ) throws NoUpdatesException {
		DatabaseConstraint oldDatabaseConstraint = (DatabaseConstraint) getPreUpdateState();
		String oldMessageText = oldDatabaseConstraint.messageText;
		final boolean noNewMessageText = messageText == null || messageText.trim().length() == 0;
		final boolean noOldMessageText = oldMessageText == null || oldMessageText.trim().length() == 0;

		try {
			DmlUpdateCommand cmd1 = dbUpdateCommand(RELVARNAMES.DATABASECONSTRAINT);
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update DatabaseConstraint
					return cmd1;
				} else {
					// now present, update DatabaseConstraint plus add
					return new DmlMultipleAssignmentCommand(new DmlAssignmentCommand[] { cmd1, dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) });
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update DatabaseConstraint plus delete
					return new DmlMultipleAssignmentCommand(new DmlAssignmentCommand[] { cmd1, oldDatabaseConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) });
				} else {
					// still present, update DatabaseConstraint plus MessageText
					try {
						return new DmlMultipleAssignmentCommand(new DmlAssignmentCommand[] { cmd1, dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) });
					} catch (NoUpdatesException e) {
						return cmd1;
					}
				}
			}
		} catch (NoUpdatesException e1) {
			if (noOldMessageText) {
				// No message text was present
				if (noNewMessageText) {
					// still not present, only update DatabaseConstraint (which means : nothing to do)
					throw e1;
				} else {
					// now present, update DatabaseConstraint plus add
					return dbAddCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT);
				}
			} else {
				// Message text was present
				if (noNewMessageText) {
					// now not present, update DatabaseConstraint plus delete
					return oldDatabaseConstraint.dbDeleteCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT);
				} else {
					// still present, update DatabaseConstraint plus MessageText
					try {
						return dbUpdateCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT);
					} catch (NoUpdatesException e) {
						throw e1;
					}
				}
			}
		}
		// return cmds;
	}
}
