/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "DbmsFile" })
public final class DbmsFile extends AbstractUpdatableDBObject implements DBObjectToDbmsfile, DbmsfileToDBObject {

	/**
	 * The file name
	 */
	private String fileName;

	/**
	 * The page size
	 */
	private int pageSize;

	/**
	 * The pre-update state
	 */
	private DbmsFile preUpdateState;

	/**
	 * 
	 */
	public DbmsFile ( ) {

	}

	/**
	 * @param fileName
	 *            The file name
	 * @param pageSize
	 *            The page size
	 */
	public DbmsFile (String fileName, int pageSize) {
		this.fileName = fileName.toUpperCase();
		this.pageSize = pageSize;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getDbmsfileFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets The page size
	 * 
	 * @return Returns the pageSize.
	 */
	public final String getDbmsfilePagesize ( ) {
		return Integer.toString(pageSize);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * Gets The page size
	 * 
	 * @return Returns the pageSize.
	 */
	public final int getPageSize ( ) {
		return pageSize;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFilenameFromDB (String fileName) {
		try {
			this.fileName = BracketParser.unMeta(fileName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The page size
	 * 
	 * @param pageSize
	 *            The page size.
	 */
	public final void setPageSize (int pageSize) {
		this.pageSize = pageSize;
	}

	/**
	 * Sets The page size
	 * 
	 * @param pageSize
	 *            The page size.
	 */
	public final void setPagesizeFromDB (String pageSize) {
		this.pageSize = Integer.parseInt(pageSize);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new DbmsFile(fileName, pageSize);
	}
}