/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * A read-only class to represent the results of an invocation of EXPRESSIONINFO
 * 
 * @author Erwin
 */
public final class ExpressionInfo implements DBObject {

	/**
	 * The set of database constraint checks that will correspond to this expression being used as the definition of a database constraint
	 */
	private AbstractRelation dbcChecks;

	/**
	 * The expression
	 */
	private String expression;

	/**
	 * 
	 */
	private AbstractRelation insertsDeletesInvocations;

	/**
	 * The set of involved types.
	 */
	private AbstractRelation involvedTypes;

	/**
	 * The set of attributes and their corresponding type that define the precise RELATION or TUPLE return type
	 */
	private AbstractRelation nonScalarHeading;

	/**
	 * 
	 */
	private AbstractRelation referencedParameters;

	/**
	 * 
	 */
	private AbstractRelation referencedRelvars;

	/**
	 * The page size
	 */
	private String returnTypeName;

	/**
	 * 
	 */
	public ExpressionInfo ( ) {

	}

	/**
	 * Gets dbcChecks
	 *
	 * @return dbcChecks.
	 */
	public final AbstractRelation getDbcChecks ( ) {
		return dbcChecks;
	}

	/**
	 * Gets diTransactionReferences
	 * 
	 * @return diTransactionReferences.
	 */
	public final AbstractRelation getInsertsDeletesInvocations ( ) {
		return insertsDeletesInvocations;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/**
	 * Gets involvedTypes
	 *
	 * @return involvedTypes.
	 */
	public final AbstractRelation getInvolvedTypes ( ) {
		return involvedTypes;
	}

	/**
	 * Gets nonScalarHeading
	 *
	 * @return nonScalarHeading.
	 */
	public final AbstractRelation getNonScalarHeading ( ) {
		return nonScalarHeading;
	}

	/**
	 * Gets referencedParameters
	 * 
	 * @return referencedParameters.
	 */
	public final AbstractRelation getReferencedParameters ( ) {
		return referencedParameters;
	}

	/**
	 * Gets referencedRelvars
	 * 
	 * @return referencedRelvars.
	 */
	public final AbstractRelation getReferencedRelvars ( ) {
		return referencedRelvars;
	}

	/**
	 * Gets The page size
	 * 
	 * @return Returns the pageSize.
	 */
	public final String getReturnTypeName ( ) {
		return returnTypeName;
	}

	/**
	 * Sets The set of database constraint checks that will correspond to this expression being used as the definition of a database constraint
	 * 
	 * @param dbcChecks
	 *            The set of database constraint checks that will correspond to this expression being used as the definition of a database constraint
	 */
	public final void setDbcchecksFromDB (AbstractRelation dbcChecks) {
		this.dbcChecks = dbcChecks;
	}

	/**
	 * Sets The set of referenced parameters
	 * 
	 * @param insertsDeletesInvocations
	 *            The page size.
	 */
	public final void setInsertsdeletesinvocationsFromDB (AbstractRelation insertsDeletesInvocations) {
		this.insertsDeletesInvocations = insertsDeletesInvocations;
	}

	/**
	 * Sets The set of involved types
	 * 
	 * @param involvedTypes
	 *            The set of involved types.
	 */
	public final void setInvolvedtypesFromDB (AbstractRelation involvedTypes) {
		this.involvedTypes = involvedTypes;
	}

	/**
	 * Sets The set of attributes and their corresponding type that define the precise RELATION or TUPLE return type
	 * 
	 * @param nonScalarHeading
	 *            The set of attributes and their corresponding type that define the precise RELATION or TUPLE return type
	 */
	public final void setNonscalarheadingFromDB (AbstractRelation nonScalarHeading) {
		this.nonScalarHeading = nonScalarHeading;
	}

	/**
	 * Sets The set of referenced parameters
	 * 
	 * @param referencedParameters
	 *            The page size.
	 */
	public final void setReferencedparametersFromDB (AbstractRelation referencedParameters) {
		this.referencedParameters = referencedParameters;
	}

	/**
	 * Sets The set of referenced parameters
	 * 
	 * @param referencedRelvars
	 *            The page size.
	 */
	public final void setReferencedrelvarsFromDB (AbstractRelation referencedRelvars) {
		this.referencedRelvars = referencedRelvars;
	}

	/**
	 * Sets The file name
	 * 
	 * @param expression
	 *            The file name.
	 */
	public final void setSp_expressionFromDB (String expression) {
		try {
			this.expression = BracketParser.unMeta(expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The page size
	 * 
	 * @param returnTypeName
	 *            The page size.
	 */
	public final void setTypenameFromDB (String returnTypeName) {
		this.returnTypeName = returnTypeName.toUpperCase();
	}

}
