/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * The GetterMethod annotation documents the name of, type of, escaping requirement for the value of, and relvarname for the attribute corresponding to a getter/setter method.  The annotation elements are all arrays, the elements of which define the way how the annotated getter method fits in the JSBA to provide attribute values for database assignment commands.
 * 
 * The annotation type is experimental and currently unused
 * 
 * @author Erwin
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface GetterMethod {
	/**
	 * The names of the corresponding relvar(s) for which this getter method is to be used by the jsba, when constructing assignment commands for a DBObject [of a class in which the annotation appears]. The set of Relvar names mentioned in a JSBAGetterMethod annotation, must be a subset of the set of Relvar names mentioned in the class-level ForRelvars annotation of the DBObject's class.
	 */
	String[] relvarNames();

	/**
	 * The name(s) of the attribute in the respective relvar(s) named in this annotation. The length this array must be equal to the length of the array of Relvar names, with the sole exception for the case when the attribute name is the same for all relvars (in which case this array is allowed to have only one element).
	 */
	String[] attributeNames();

	/**
	 * The typeName(s) of the attribute in the respective relvars. This array must be equal in length to the attributeName[] array, with the sole exception for the case where the typeName is the same for all attributes (in which case this array is allowed to have only one element, while the attributeNames[] array has more).
	 */
	String[] typeNames();

	/**
	 * Flag(s) indicating whether the attribute's type requires escape processing. True if string representations of any value of the type can validly include any of '(', ')', '\'.
	 */
	boolean[] requiresEscaping();

}
