/**
 * 
 */
package be.SIRAPRISE.client.jsba;

/**
 * GetterMethodKeys are containers holding the key elements that determine the set of getter methods that can be derived from a given DBObject class, given a relvar name.
 * 
 * @author Erwin
 * 
 */
public final class GetterMethodKey {

	/**
	 * 
	 */
	private String jsbaCanonicalRelvarName;

	/**
	 * 
	 */
	private Class<?> clazz;

	/**
	 * 
	 */
	private int hashCode;

	/**
	 * Creates the JSBAGetterMethodKey
	 * 
	 * @param inspectedClass
	 *            The class
	 * @param jsbaCanonicalRelvarName
	 *            the relvar name in canonical JSBA format
	 */
	public GetterMethodKey (Class<?> inspectedClass, String jsbaCanonicalRelvarName) {
		this.clazz = inspectedClass;
		this.jsbaCanonicalRelvarName = jsbaCanonicalRelvarName;
		this.hashCode = clazz.hashCode() ^ jsbaCanonicalRelvarName.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals (Object obj) {
		return obj instanceof GetterMethodKey ? (((GetterMethodKey) obj).clazz.equals(clazz) && ((GetterMethodKey) obj).jsbaCanonicalRelvarName.equals(jsbaCanonicalRelvarName)) : false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode ( ) {
		return hashCode;
	}

}
