/*
 * Created on 11-nov-2008
 */
package be.SIRAPRISE.client.jsba;


/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "Index", "TupleIndex" })
public final class Index extends AbstractUpdatableDBObject implements DBObjectToIndex, IndexToDBObject, DBObjectToTupleindex, TupleindexToDBObject {

	/**
	 * Comment for <code>fileName</code>
	 */
	private String fileName;

	/**
	 * Comment for <code>IndexName</code>
	 */
	private String name;

	/**
	 * Comment for <code>preUpdateState</code>
	 */
	private Index preUpdateState;

	/**
	 * Comment for <code>recordTypeName</code>
	 */
	private String recordTypeName;

	/**
	 * Comment for <code>relvarName</code>
	 */
	private String relvarName;

	/**
	 * Comment for <code>storageSpaceID</code>
	 */
	private int storageSpaceID;

	/**
	 * 
	 */
	public Index ( ) {
		this.relvarName = ""; //$NON-NLS-1$
		this.name = ""; //$NON-NLS-1$
		this.recordTypeName = ""; //$NON-NLS-1$
		this.fileName = ""; //$NON-NLS-1$
		this.storageSpaceID = -1;
	}

	/**
	 * @param relvarName
	 * @param indexName
	 * @param recordTypeName
	 * @param fileName
	 * @param storageSpaceID
	 */
	public Index (String relvarName, String indexName, String recordTypeName, String fileName, int storageSpaceID) {
		this.relvarName = relvarName.toUpperCase();
		this.name = indexName.toUpperCase();
		this.recordTypeName = recordTypeName.toUpperCase();
		this.fileName = fileName.toUpperCase();
		this.storageSpaceID = storageSpaceID;
	}

	/**
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndex#getIndexFilename()
	 */
	public String getIndexFilename ( ) {
		return fileName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndex#getIndexIndexname()
	 */
	public String getIndexIndexname ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndex#getINDEX_RECORDTYPEname()
	 */
	public String getIndexRecordtypename ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndex#getIndexRelvarname()
	 */
	public String getIndexRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndex#getIndexStoragespaceid()
	 */
	public String getIndexStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * @return Returns the indexName.
	 */
	public final String getName ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * @return Returns the recordTypeName.
	 */
	public final String getRecordTypeName ( ) {
		return recordTypeName;
	}

	/**
	 * @return Returns the relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * @return Returns the storageSpaceID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTUPLEINDEX_INDEXname()
	 */
	@Override
	public String getTupleindexIndexname ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTupleINDEX_RECORDTYPEname()
	 */
	@Override
	public String getTupleindexRecordtypename ( ) {
		return recordTypeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTupleindex#getTupleindexRelvarname()
	 */
	@Override
	public String getTupleindexRelvarname ( ) {
		return relvarName;
	}

	/**
	 * @param fileName
	 *            The fileName to set.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexToDBObject#setFilenameFromDB(java.lang.String)
	 */
	public final void setFilenameFromDB (String filename) {
		this.fileName = filename.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexToDBObject#setIndexnameFromDB(java.lang.String)
	 */
	public final void setIndexnameFromDB (String indexname) {
		this.name = indexname.toUpperCase();
	}

	/**
	 * @param indexName
	 *            The indexName to set.
	 */
	public final void setName (String indexName) {
		this.name = indexName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new Index(relvarName, name, recordTypeName, fileName, storageSpaceID);
	}

	/**
	 * @param recordTypeName
	 *            The recordTypeName to set.
	 */
	public final void setRecordTypeName (String recordTypeName) {
		this.recordTypeName = recordTypeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexToDBObject#setRecordtypenameFromDB(java.lang.String)
	 */
	public final void setRecordtypenameFromDB (String recordtypename) {
		this.recordTypeName = recordtypename.toUpperCase();
	}

	/**
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public final void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

	/**
	 * @param storageSpaceID
	 *            The storageSpaceID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexToDBObject#setStoragespaceidFromDB(java.lang.String)
	 */
	public final void setStoragespaceidFromDB (String storagespaceid) {
		this.storageSpaceID = Integer.parseInt(storagespaceid);
	}
}