/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "IndexComponenent" })
public final class IndexComponent extends AbstractUpdatableDBObject implements IndexcomponentToDBObject, DBObjectToIndexcomponent {

	/**
	 * 
	 */
	private String expression;

	/**
	 * 
	 */
	private String indexName;

	/**
	 * 
	 */
	private int ordinal;

	/**
	 * 
	 */
	private UpdatableDBObject preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the IndexComponent
	 *
	 */
	public IndexComponent () {
		this.relvarName = ""; //$NON-NLS-1$
		this.indexName = ""; //$NON-NLS-1$
		this.ordinal = -1;
		this.expression = ""; //$NON-NLS-1$
	}

	/**
	 * Creates the IndexComponent
	 *
	 * @param relvarName
	 * @param indexName
	 * @param ordinal
	 * @param expression
	 */
	public IndexComponent (String relvarName, String indexName, int ordinal, String expression) {
		this.relvarName = relvarName.toUpperCase();
		this.indexName = indexName.toUpperCase();
		this.ordinal = ordinal;
		this.expression = expression;
	}

	/**
	 * Gets expression
	 *
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndexcomponent#getIndexcomponentExpression()
	 */
	public String getIndexcomponentSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndexcomponent#getINDEXCOMPONENT_INDEXname()
	 */
	public String getIndexcomponentIndexname ( ) {
		return indexName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndexcomponent#getIndexcomponentOrdinal()
	 */
	public String getIndexcomponentOrdinal ( ) {
		return Integer.toString(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToIndexcomponent#getIndexcomponentRelvarname()
	 */
	public String getIndexcomponentRelvarname ( ) {
		return relvarName;
	}

	/**
	 * Gets indexName
	 *
	 * @return indexName.
	 */
	public final String getIndexName ( ) {
		return indexName;
	}

	/**
	 * Gets ordinal
	 *
	 * @return ordinal.
	 */
	public final int getOrdinal ( ) {
		return ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 *
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets expression
	 *
	 * @param expression The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexcomponentToDBObject#setExpressionFromDB(java.lang.String)
	 */
	public void setSp_expressionFromDB (String expression) {
		try {
			this.expression = BracketParser.unMeta(expression);
		} catch (InvalidEscapedCharacterException e) {
			throw new IllegalArgumentException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new IllegalArgumentException(e);
		}
	}

	/**
	 * Sets indexName
	 *
	 * @param indexName The indexName to set.
	 */
	public final void setIndexName (String indexName) {
		this.indexName = indexName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexcomponentToDBObject#setIndexnameFromDB(java.lang.String)
	 */
	public void setIndexnameFromDB (String indexname) {
		this.indexName = indexname.toUpperCase();
	}

	/**
	 * Sets ordinal
	 *
	 * @param ordinal The ordinal to set.
	 */
	public final void setOrdinal (int ordinal) {
		this.ordinal = ordinal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexcomponentToDBObject#setOrdinalFromDB(java.lang.String)
	 */
	public void setOrdinalFromDB (String ordinal) {
		this.ordinal = Integer.parseInt(ordinal);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new IndexComponent(relvarName, indexName, ordinal, expression);
	}

	/**
	 * Sets relvarName
	 *
	 * @param relvarName The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.IndexcomponentToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}
}
