/**
 * 
 */
package be.SIRAPRISE.client.jsba;

import java.lang.reflect.InvocationTargetException;

/**
 * @author Erwin
 * 
 */
public abstract class JSBAMethodInvoker {

	/**
	 * Invokes a JSBA getter method and converts the result of the invocation to a String representation
	 * 
	 * @param o
	 *            The object on which a JSBA getter method is to be invoked
	 * @param objects
	 *            Parameters to be passed to the getter method, should be null
	 * @return The String representation of the result of invoking a getter method
	 * @throws InvocationTargetException
	 * @throws IllegalAccessException
	 * @throws IllegalArgumentException
	 */
	public abstract String invoke (Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

}
