/**
 * 
 */
package be.SIRAPRISE.client.jsba;


/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "JavaBackedType", "TypeProperties" })
public final class JavaBackedType extends AbstractUpdatableDBObject implements JavabackedtypeToDBObject, TypepropertiesToDBObject, DBObjectToJavabackedtype, DBObjectToTypeproperties {

	/**
	 * 
	 */
	private int maximumSize;

	/**
	 * 
	 */
	private int minimumSize;

	/**
	 * 
	 */
	private String name;

	/**
	 * 
	 */
	private boolean ordered;

	/**
	 * 
	 */
	private JavaBackedType preUpdateState;

	/**
	 * 
	 */
	private boolean scalar;

	/**
	 * Creates the Type
	 */
	public JavaBackedType ( ) {

	}

	/**
	 * Creates the Type
	 * 
	 * @param typeName
	 */
	public JavaBackedType (String typeName) {
		this(typeName, false, true, 1, 1);
	}

	/**
	 * Creates the Type
	 * 
	 * @param typeName
	 * @param ordered
	 * @param scalar
	 * @param minimumSize
	 * @param maximumSize
	 */
	public JavaBackedType (String typeName, boolean ordered, boolean scalar, int minimumSize, int maximumSize) {
		this.name = typeName;
		this.ordered = ordered;
		this.scalar = scalar;
		this.minimumSize = minimumSize;
		this.maximumSize = maximumSize;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToType#getTypeTypename()
	 */
	@Override
	public String getJavabackedtypeTypename ( ) {
		return name;
	}

	/**
	 * Gets maximumSize
	 * 
	 * @return maximumSize.
	 */
	public final int getMaximumSize ( ) {
		return maximumSize;
	}

	/**
	 * Gets minimumSize
	 * 
	 * @return minimumSize.
	 */
	public final int getMinimumSize ( ) {
		return minimumSize;
	}

	/**
	 * Gets typeName
	 * 
	 * @return typeName.
	 */
	public final String getName ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTypeproperties#getTypepropertiesIsordered()
	 */
	@Override
	public String getTypepropertiesIsordered ( ) {
		return Boolean.toString(ordered);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTypeproperties#getTypepropertiesIsscalar()
	 */
	@Override
	public String getTypepropertiesIsscalar ( ) {
		return Boolean.toString(scalar);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTypeproperties#getTypepropertiesMaximumsize()
	 */
	@Override
	public String getTypepropertiesMaximumsize ( ) {
		return Integer.toString(maximumSize);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTypeproperties#getTypepropertiesMinimumsize()
	 */
	@Override
	public String getTypepropertiesMinimumsize ( ) {
		return Integer.toString(minimumSize);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToTypeproperties#getTypepropertiesTypename()
	 */
	@Override
	public String getTypepropertiesTypename ( ) {
		return name;
	}

	/**
	 * Gets ordered
	 * 
	 * @return ordered.
	 */
	public final boolean isOrdered ( ) {
		return ordered;
	}

	/**
	 * Gets scalar
	 * 
	 * @return scalar.
	 */
	public final boolean isScalar ( ) {
		return scalar;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TypepropertiesToDBObject#setIsorderedFromDB(java.lang.String)
	 */
	@Override
	public void setIsorderedFromDB (String isordered) {
		this.ordered = Boolean.parseBoolean(isordered);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TypepropertiesToDBObject#setIsscalarFromDB(java.lang.String)
	 */
	@Override
	public void setIsscalarFromDB (String isscalar) {
		this.scalar = Boolean.parseBoolean(isscalar);
	}

	/**
	 * Sets maximumSize
	 * 
	 * @param maximumSize
	 *            The maximumSize to set.
	 */
	public final void setMaximumSize (int maximumSize) {
		this.maximumSize = maximumSize;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TypepropertiesToDBObject#setMaximumsizeFromDB(java.lang.String)
	 */
	@Override
	public void setMaximumsizeFromDB (String maximumsize) {
		this.maximumSize = Integer.parseInt(maximumsize);
	}

	/**
	 * Sets minimumSize
	 * 
	 * @param minimumSize
	 *            The minimumSize to set.
	 */
	public final void setMinimumSize (int minimumSize) {
		this.minimumSize = minimumSize;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TypepropertiesToDBObject#setMinimumsizeFromDB(java.lang.String)
	 */
	@Override
	public void setMinimumsizeFromDB (String minimumsize) {
		this.minimumSize = Integer.parseInt(minimumsize);
	}

	/**
	 * Sets typeName
	 * 
	 * @param typeName
	 *            The typeName to set.
	 */
	public final void setName (String typeName) {
		this.name = typeName;
	}

	/**
	 * Sets ordered
	 * 
	 * @param ordered
	 *            The ordered to set.
	 */
	public final void setOrdered (boolean ordered) {
		this.ordered = ordered;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new JavaBackedType(name, ordered, scalar, minimumSize, maximumSize);
	}

	/**
	 * Sets scalar
	 * 
	 * @param scalar
	 *            The scalar to set.
	 */
	public final void setScalar (boolean scalar) {
		this.scalar = scalar;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.TypeToDBObject#setTypenameFromDB(java.lang.String)
	 */
	@Override
	public void setTypenameFromDB (String typename) {
		this.name = typename;
	}

}
