/**
 * 
 */
package be.SIRAPRISE.client.jsba;


/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "Key" })
public final class Key extends AbstractUpdatableDBObject implements DBObjectToKey, KeyToDBObject {

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private Key preUpdateState;

	/**
	 * 
	 */
	private String relvarName;

	/**
	 * Creates the Key
	 * 
	 */
	public Key ( ) {
		this("", -1); //$NON-NLS-1$
	}

	/**
	 * Creates the Key
	 * 
	 * @param relvarName
	 * @param errorCode
	 */
	public Key (String relvarName, long errorCode) {
		this.relvarName = relvarName.toUpperCase();
		this.errorCode = errorCode;
	}

	/**
	 * Gets keyID
	 * 
	 * @return keyID.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToKey#getKeyKeyid()
	 */
	public String getKeyErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToKey#getKEY_RELVARname()
	 */
	public String getKeyRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 * 
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets keyID
	 * 
	 * @param errorCode
	 *            The keyID to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.KeyToDBObject#setKeyidFromDB(java.lang.String)
	 */
	public void setErrorcodeFromDB (String errorCode) {
		this.errorCode = Long.parseLong(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new Key(relvarName, errorCode);
	}

	/**
	 * Sets relvarName
	 * 
	 * @param relvarName
	 *            The relvarName to set.
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.KeyToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname.toUpperCase();
	}

}
