/**
 * 
 */
package be.SIRAPRISE.client.jsba;


/**
 * @author Erwin
 * 
 */
@ForRelvars(relvarNames = { "KeyAttribute" })
public final class KeyAttribute extends AbstractUpdatableDBObject implements DBObjectToKeyattribute, KeyattributeToDBObject {

	/**
	 * 
	 */
	private String attributeName;

	/**
	 * 
	 */
	private long errorCode;

	/**
	 * 
	 */
	private KeyAttribute preUpdateState;

	/**
	 * Creates the KeyAttribute
	 * 
	 */
	public KeyAttribute ( ) {
		this(-1, ""); //$NON-NLS-1$
	}

	/**
	 * Creates the KeyAttribute
	 * 
	 * @param errorCode
	 * @param attributeName
	 */
	public KeyAttribute (long errorCode, String attributeName) {
		this.errorCode = errorCode;
		this.attributeName = attributeName.toUpperCase();
	}

	/**
	 * Gets attributeName
	 * 
	 * @return attributeName.
	 */
	public final String getAttributeName ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToKeyattribute#getKeyattributeAttributename()
	 */
	public String getKeyattributeAttributename ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToKeyattribute#getKEYATTRIBUTE_KEYid()
	 */
	public String getKeyattributeErrorcode ( ) {
		return Long.toString(errorCode);
	}

	/**
	 * Gets keyID
	 * 
	 * @return keyID.
	 */
	public final long getErrorCode ( ) {
		return errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Sets attributeName
	 * 
	 * @param attributeName
	 *            The attributeName to set.
	 */
	public final void setAttributeName (String attributeName) {
		this.attributeName = attributeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.KeyattributeToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	public void setAttributenameFromDB (String attributename) {
		this.attributeName = attributename.toUpperCase();
	}

	/**
	 * Sets keyID
	 * 
	 * @param errorCode
	 *            The keyID to set.
	 */
	public final void setErrorCode (long errorCode) {
		this.errorCode = errorCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.KeyattributeToDBObject#setKeyidFromDB(java.lang.String)
	 */
	public void setErrorcodeFromDB (String errorCode) {
		this.errorCode = Long.parseLong(errorCode);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public void setPreUpdateState ( ) {
		preUpdateState = new KeyAttribute(errorCode, attributeName);
	}

}
