/*
 * Created on 24-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "MultiHashingIndexSpace", "StorageSpace" })
public final class MultiHashingIndexSpace extends AbstractUpdatableDBObject implements DBObjectToMultihashingindexspace, DBObjectToStoragespace, MultihashingindexspaceToDBObject, StoragespaceToDBObject {

	/**
	 * The number of extents that the storage space can take
	 */
	private int extentsCount;

	/**
	 * The file name
	 */
	private String fileName;

	/**
	 * The gap compression threshold
	 */
	private int gapCompressionThreshold;

	/**
	 * The maximum gap count
	 */
	private int maximumGaps;

	/**
	 * The number of pages in the index space
	 */
	private int pageCount;

	/**
	 * The pre-update state
	 */
	private MultiHashingIndexSpace preUpdateState;

	/**
	 * The ID
	 */
	private int storageSpaceID;

	/**
	 * 
	 */
	public MultiHashingIndexSpace ( ) {

	}

	/**
	 * @param fileName
	 *            The file name
	 * @param storageSpaceID
	 *            The ID
	 * @param pageCount
	 *            The number of pages in the index space
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 * @param maximumGaps
	 *            The maximum gap count
	 * @param extentsCount
	 *            The number of extents that the storage space can take
	 */
	public MultiHashingIndexSpace (String fileName, int storageSpaceID, int pageCount, int gapCompressionThreshold, int maximumGaps, int extentsCount) {
		this.fileName = fileName.toUpperCase();
		this.storageSpaceID = storageSpaceID;
		this.pageCount = pageCount;
		this.gapCompressionThreshold = gapCompressionThreshold;
		this.maximumGaps = maximumGaps;
		this.extentsCount = extentsCount;
	}

	/**
	 * Gets The number of extents that the storage space can take
	 * 
	 * @return The number of extents that the storage space can take
	 */
	public final int getExtentsCount ( ) {
		return extentsCount;
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getFileName ( ) {
		return fileName;
	}

	/**
	 * Gets The gap compression threshold
	 * 
	 * @return The gap compression threshold
	 */
	public final int getGapCompressionThreshold ( ) {
		return gapCompressionThreshold;
	}

	/**
	 * Gets The maximum gap count
	 * 
	 * @return The maximum gap count
	 */
	public final int getMaximumGaps ( ) {
		return maximumGaps;
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getMultihashingindexspaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getMultihashingindexspaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getMultihashingindexspaceGapcompressionthreshold ( ) {
		return Integer.toString(gapCompressionThreshold);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getMultihashingindexspaceMaximumgaps ( ) {
		return Integer.toString(maximumGaps);
	}

	/**
	 * Gets The number of pages in the index space
	 * 
	 * @return The number of pages in the index space
	 */
	public final int getPageCount ( ) {
		return pageCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.webclient.DBObjectToStoragespace#getStoragespaceExtentscount()
	 */
	@Override
	public String getStoragespaceExtentscount ( ) {
		return Integer.toString(extentsCount);
	}

	/**
	 * Gets The file name
	 * 
	 * @return Returns the fileName.
	 */
	public final String getStoragespaceFilename ( ) {
		return BracketParser.meta(fileName);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final int getStorageSpaceID ( ) {
		return storageSpaceID;
	}

	/**
	 * Gets The gap compression threshold
	 * 
	 * @return The gap compression threshold
	 */
	public final String getStoragespacePagecount ( ) {
		return Integer.toString(pageCount);
	}

	/**
	 * Gets the ID
	 * 
	 * @return the ID.
	 */
	public final String getStoragespaceStoragespaceid ( ) {
		return Integer.toString(storageSpaceID);
	}

	/**
	 * Sets The number of extents that the storage space can take
	 * 
	 * @param extentsCount
	 *            The number of extents that the storage space can take
	 */
	public final void setExtentsCount (int extentsCount) {
		this.extentsCount = extentsCount;
	}

	/**
	 * Sets The number of extents that the storage space can take
	 * 
	 * @param extentsCount
	 *            The number of extents that the storage space can take
	 */
	public final void setExtentscountFromDB (String extentsCount) {
		this.extentsCount = Integer.parseInt(extentsCount);
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFileName (String fileName) {
		this.fileName = fileName.toUpperCase();
	}

	/**
	 * Sets The file name
	 * 
	 * @param fileName
	 *            The file name.
	 */
	public final void setFilenameFromDB (String fileName) {
		try {
			this.fileName = BracketParser.unMeta(fileName).toUpperCase();
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Sets The gap compression threshold
	 * 
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 */
	public final void setGapCompressionThreshold (int gapCompressionThreshold) {
		this.gapCompressionThreshold = gapCompressionThreshold;
	}

	/**
	 * Sets The gap compression threshold
	 * 
	 * @param gapCompressionThreshold
	 *            The gap compression threshold
	 */
	public final void setGapcompressionthresholdFromDB (String gapCompressionThreshold) {
		this.gapCompressionThreshold = Integer.parseInt(gapCompressionThreshold);
	}

	/**
	 * Gets The maximum gap count
	 * 
	 * @param maximumGaps
	 *            The maximum gap count.
	 */
	public final void setMaximumGaps (int maximumGaps) {
		this.maximumGaps = maximumGaps;
	}

	/**
	 * Sets The maximum gap count
	 * 
	 * @param maximumGaps
	 *            The maximum gap count.
	 */
	public final void setMaximumgapsFromDB (String maximumGaps) {
		this.maximumGaps = Integer.parseInt(maximumGaps);
	}

	/**
	 * Sets The number of pages in the index space
	 * 
	 * @param pageCount
	 *            The number of pages in the index space
	 */
	public final void setPageCount (int pageCount) {
		this.pageCount = pageCount;
	}

	/**
	 * Sets The number of pages in the index space
	 * 
	 * @param pageCount
	 *            The number of pages in the index space
	 */
	public final void setPagecountFromDB (String pageCount) {
		this.pageCount = Integer.parseInt(pageCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new MultiHashingIndexSpace(fileName, storageSpaceID, pageCount, gapCompressionThreshold, maximumGaps, extentsCount);
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStorageSpaceID (int storageSpaceID) {
		this.storageSpaceID = storageSpaceID;
	}

	/**
	 * Sets the ID
	 * 
	 * @param storageSpaceID
	 *            The ID to set.
	 */
	public final void setStoragespaceidFromDB (String storageSpaceID) {
		this.storageSpaceID = Integer.parseInt(storageSpaceID);
	}
}