/*
 * Created on 12-nov-2008
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

/**
 * @author Erwin Smout
 */
@ForRelvars(relvarNames = { "NewAttributeDefaultValue" })
public final class NewAttributeDefaultValue extends AbstractUpdatableDBObject implements DBObjectToNewattributedefaultvalue, NewattributedefaultvalueToDBObject {

	/**
	 * The [name of the] new attribute
	 */
	private String attributeName;

	/**
	 * The expression for computing the value to be registered for the new attribute of the given name, in existing tuples of the relvar with the given name
	 */
	private String expression;

	/**
	 * The pre-update state
	 */
	private NewAttributeDefaultValue preUpdateState;

	/**
	 * The [name of the] relvar to which a new attribute is being added
	 */
	private String relvarName;

	/**
	 * 
	 */
	public NewAttributeDefaultValue ( ) {

	}

	/**
	 * @param relvarName
	 *            The [name of the] relvar to which a new attribute is being added
	 * @param attributeName
	 *            The [name of the] new attribute
	 * @param expression
	 *            The expression for computing the value to be registered for the new attribute of the given name, in existing tuples of the relvar with the given name
	 */
	public NewAttributeDefaultValue (String relvarName, String attributeName, String expression) {
		this.relvarName = relvarName.toUpperCase();
		this.attributeName = attributeName.toUpperCase();
		this.expression = expression;
	}

	/**
	 * Gets The [name of the] new attribute
	 *
	 * @return The [name of the] new attribute
	 */
	public final String getAttributeName ( ) {
		return attributeName;
	}

	/**
	 * Gets expression
	 *
	 * @return expression.
	 */
	public final String getExpression ( ) {
		return expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.DBObjectToNewattributedefaultvalue#getNewattributedefaultvalueAttributename()
	 */
	@Override
	public String getNewattributedefaultvalueAttributename ( ) {
		return attributeName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.DBObjectToNewattributedefaultvalue#getNewattributedefaultvalueRelvarname()
	 */
	@Override
	public String getNewattributedefaultvalueRelvarname ( ) {
		return relvarName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.DBObjectToNewattributedefaultvalue#getNewattributedefaultvalueSp_expression()
	 */
	@Override
	public String getNewattributedefaultvalueSp_expression ( ) {
		return BracketParser.meta(expression);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	public final UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets relvarName
	 *
	 * @return relvarName.
	 */
	public final String getRelvarName ( ) {
		return relvarName;
	}

	/**
	 * Sets The [name of the] new attribute
	 *
	 * @param attributeName The [name of the] new attribute
	 */
	public final void setAttributeName (String attributeName) {
		this.attributeName = attributeName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.NewattributedefaultvalueToDBObject#setAttributenameFromDB(java.lang.String)
	 */
	@Override
	public void setAttributenameFromDB (String attributename) {
		this.attributeName = attributename;
	}

	/**
	 * Sets expression
	 *
	 * @param expression The expression to set.
	 */
	public final void setExpression (String expression) {
		this.expression = expression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	public final void setPreUpdateState ( ) {
		preUpdateState = new NewAttributeDefaultValue(relvarName, attributeName, expression);
	}

	/**
	 * Sets The [name of the] relvar to which a new attribute is being added
	 *
	 * @param relvarName The [name of the] relvar to which a new attribute is being added
	 */
	public final void setRelvarName (String relvarName) {
		this.relvarName = relvarName.toUpperCase();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.NewattributedefaultvalueToDBObject#setRelvarnameFromDB(java.lang.String)
	 */
	@Override
	public void setRelvarnameFromDB (String relvarname) {
		this.relvarName = relvarname;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.jsba.NewattributedefaultvalueToDBObject#setSp_expressionFromDB(java.lang.String)
	 */
	@Override
	public void setSp_expressionFromDB (String spExpression) {
		try {
			this.expression = BracketParser.unMeta(spExpression);
		} catch (InvalidEscapedCharacterException e) {
			throw new RuntimeException(e);
		} catch (MissingEscapedCharacterException e) {
			throw new RuntimeException(e);
		}
	}
}